/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.dbcdata;

import JinRyuu.DragonBC.common.DBCKiTech;
import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.JRMCoreHDBC;
import JinRyuu.JRMCore.entity.EntityCusPar;
import JinRyuu.JRMCore.server.config.dbc.JGConfigUltraInstinct;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.constants.DBCRace;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.DBCEffectController;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.controllers.TransformController;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCDataBonus;
import kamkeel.npcdbc.data.dbcdata.DBCDataStats;
import kamkeel.npcdbc.data.dbcdata.DBCDataUniversal;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.entity.EntityAura;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.packets.player.DBCSetFlight;
import kamkeel.npcdbc.network.packets.player.DBCUpdateLockOn;
import kamkeel.npcdbc.network.packets.player.PingPacket;
import kamkeel.npcdbc.network.packets.player.TurboPacket;
import kamkeel.npcdbc.util.DBCUtils;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.controllers.CustomEffectController;
import noppes.npcs.controllers.data.EffectKey;
import noppes.npcs.controllers.data.PlayerEffect;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.util.ValueUtil;

public class DBCData
extends DBCDataUniversal
implements IAuraData {
    public static String DBCPersisted = "PlayerPersisted";
    public final Side side;
    public EntityPlayer player;
    public int STR;
    public int DEX;
    public int CON;
    public int WIL;
    public int MND;
    public int SPI;
    public int TP;
    public int Body;
    public int Ki;
    public int Stamina;
    public int KOforXSeconds;
    public int Rage;
    public int Heat;
    public int Pain;
    public int AuraColor;
    public int ArcReserve;
    public int hasSSJ4;
    public byte Class;
    public byte Race;
    public byte Powertype;
    public byte Accept;
    public byte State;
    public byte State2;
    public byte Release;
    public byte Alignment;
    public byte Tail;
    public boolean Alive;
    public boolean isKO;
    public String Skills = "";
    public String RacialSkills = "";
    public String StatusEffects = "";
    public String Settings = "";
    public String FormMasteryRacial = "";
    public String FormMasteryNR = "";
    public String DNS = "";
    public String DNSHair = "";
    public String MajinAbsorptionData = "";
    public String Fusion = "";
    public int addonFormID = -1;
    public int auraID = -1;
    public int outlineID = -1;
    public float addonFormLevel = 0.0f;
    public float addonCurrentHeat = 0.0f;
    @SideOnly(value=Side.CLIENT)
    public Map<String, PlayerBonus> currentBonuses;
    @SideOnly(value=Side.CLIENT)
    public byte potaraFusionLevel;
    @SideOnly(value=Side.CLIENT)
    public FormDisplay.BodyColor currentCustomizedColors;
    public float baseFlightSpeed = 1.0f;
    public float dynamicFlightSpeed = 1.0f;
    public float sprintSpeed = 1.0f;
    public int flightSpeedRelease = 100;
    public boolean isFlying;
    public boolean flightEnabled = true;
    public boolean flightGravity = true;
    public boolean isFnPressed;
    public DBCDataStats stats = new DBCDataStats(this);
    public DBCDataBonus bonus = new DBCDataBonus(this);
    public float XZSize;
    public float YSize;
    public float age;
    public int renderingHairColor;
    public byte skinType;
    public boolean useStencilBuffer;
    public boolean renderGoD;
    public boolean renderKK;
    public boolean renderUI;
    public EntityAura auraEntity;
    public int activeAuraColor = -1;
    public List<EntityCusPar> particleRenderQueue = new LinkedList<EntityCusPar>();
    public int lastTicked = -1;

    public DBCData() {
        this.side = Side.SERVER;
    }

    public DBCData(EntityPlayer player) {
        this.player = player;
        Side side = this.side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        if (this.side == Side.SERVER) {
            this.loadNBTData(true);
        } else {
            this.potaraFusionLevel = (byte)-1;
        }
    }

    public NBTTagCompound saveFromNBT(NBTTagCompound comp) {
        comp.func_74768_a("jrmcStrI", this.STR);
        comp.func_74768_a("jrmcDexI", this.DEX);
        comp.func_74768_a("jrmcCnsI", this.CON);
        comp.func_74768_a("jrmcWilI", this.WIL);
        comp.func_74768_a("jrmcIntI", this.MND);
        comp.func_74768_a("jrmcCncI", this.SPI);
        comp.func_74768_a("jrmcEnrgy", this.Ki);
        comp.func_74768_a("jrmcStamina", this.Stamina);
        comp.func_74768_a("jrmcBdy", this.Body);
        comp.func_74768_a("jrmcHar4va", this.KOforXSeconds);
        comp.func_74768_a("jrmcSaiRg", this.Rage);
        comp.func_74768_a("jrmcEf8slc", this.Heat);
        comp.func_74768_a("jrmcGyJ7dp", this.Pain);
        comp.func_74768_a("jrmcAuraColor", this.AuraColor);
        comp.func_74768_a("jrmcArcRsrv", this.ArcReserve);
        comp.func_74768_a("jrmcAfGFtStFT", this.hasSSJ4);
        comp.func_74768_a("jrmcTpint", this.TP);
        comp.func_74774_a("jrmcState", this.State);
        comp.func_74774_a("jrmcState2", this.State2);
        comp.func_74774_a("jrmcRelease", this.Release);
        comp.func_74774_a("jrmcPwrtyp", this.Powertype);
        comp.func_74774_a("jrmcRace", this.Race);
        comp.func_74774_a("jrmcClass", this.Class);
        comp.func_74774_a("jrmcAccept", this.Accept);
        comp.func_74774_a("jrmcAlign", this.Alignment);
        comp.func_74774_a("jrmcTlmd", this.Tail);
        comp.func_74778_a("jrmcStatusEff", this.StatusEffects);
        comp.func_74778_a("jrmcSSltX", this.RacialSkills);
        comp.func_74778_a("jrmcSSlts", this.Skills);
        comp.func_74778_a("jrmcSettings", this.Settings);
        comp.func_74778_a("jrmcFormMasteryRacial_" + JRMCoreH.Races[this.Race], this.FormMasteryRacial);
        comp.func_74778_a("jrmcFormMasteryNonRacial", this.FormMasteryNR);
        comp.func_74778_a("jrmcDNS", this.DNS);
        comp.func_74778_a("jrmcDNSH", this.DNSHair);
        comp.func_74778_a("jrmcMajinAbsorptionData", this.MajinAbsorptionData);
        comp.func_74778_a("jrmcFuzion", this.Fusion);
        comp.func_74768_a("addonFormID", this.addonFormID);
        comp.func_74768_a("auraID", this.auraID);
        comp.func_74768_a("outlineID", this.outlineID);
        comp.func_74776_a("addonFormLevel", this.addonFormLevel);
        comp.func_74776_a("addonCurrentHeat", this.addonCurrentHeat);
        comp.func_74776_a("DBCBaseFlightSpeed", this.baseFlightSpeed);
        comp.func_74776_a("DBCDynamicFlightSpeed", this.dynamicFlightSpeed);
        comp.func_74776_a("DBCSprintSpeed", this.sprintSpeed);
        comp.func_74768_a("DBCFlightSpeedRelease", this.flightSpeedRelease);
        comp.func_74757_a("DBCisFlying", this.isFlying);
        comp.func_74757_a("DBCFlightEnabled", this.flightEnabled);
        comp.func_74757_a("DBCFlightGravity", this.flightGravity);
        comp.func_74757_a("DBCIsFnPressed", this.isFnPressed);
        return comp;
    }

    public void loadFromNBT(NBTTagCompound c) {
        this.STR = c.func_74762_e("jrmcStrI");
        this.DEX = c.func_74762_e("jrmcDexI");
        this.CON = c.func_74762_e("jrmcCnsI");
        this.WIL = c.func_74762_e("jrmcWilI");
        this.MND = c.func_74762_e("jrmcIntI");
        this.SPI = c.func_74762_e("jrmcCncI");
        this.Ki = c.func_74762_e("jrmcEnrgy");
        this.Stamina = c.func_74762_e("jrmcStamina");
        this.Body = c.func_74762_e("jrmcBdy");
        this.KOforXSeconds = c.func_74762_e("jrmcHar4va");
        this.Rage = c.func_74762_e("jrmcSaiRg");
        this.Heat = c.func_74762_e("jrmcEf8slc");
        this.Pain = c.func_74762_e("jrmcGyJ7dp");
        this.isKO = c.func_74762_e("jrmcHar4va") > 0;
        this.hasSSJ4 = c.func_74762_e("jrmcAfGFtStFT");
        this.AuraColor = c.func_74762_e("jrmcAuraColor");
        this.ArcReserve = c.func_74762_e("jrmcArcRsrv");
        this.TP = c.func_74762_e("jrmcTpint");
        this.State = c.func_74771_c("jrmcState");
        this.State2 = c.func_74771_c("jrmcState2");
        this.Release = c.func_74771_c("jrmcRelease");
        this.Powertype = c.func_74771_c("jrmcPwrtyp");
        this.Race = c.func_74771_c("jrmcRace");
        this.Class = c.func_74771_c("jrmcClass");
        this.Accept = c.func_74771_c("jrmcAccept");
        this.Alignment = c.func_74771_c("jrmcAlign");
        this.Tail = c.func_74771_c("jrmcTlmd");
        this.StatusEffects = c.func_74779_i("jrmcStatusEff");
        this.RacialSkills = c.func_74779_i("jrmcSSltX");
        this.Skills = c.func_74779_i("jrmcSSlts");
        this.Settings = c.func_74779_i("jrmcSettings");
        this.FormMasteryRacial = c.func_74779_i("jrmcFormMasteryRacial_" + JRMCoreH.Races[this.Race]);
        this.FormMasteryNR = c.func_74779_i("jrmcFormMasteryNonRacial");
        this.DNS = c.func_74779_i("jrmcDNS");
        this.DNSHair = c.func_74779_i("jrmcDNSH");
        this.MajinAbsorptionData = c.func_74779_i("jrmcMajinAbsorptionData");
        this.Fusion = c.func_74779_i("jrmcFuzion");
        this.isFlying = c.func_74767_n("DBCisFlying");
        if (!c.func_74764_b("addonFormID")) {
            c.func_74768_a("addonFormID", this.addonFormID);
        }
        this.addonFormID = c.func_74762_e("addonFormID");
        this.addonFormLevel = c.func_74760_g("addonFormLevel");
        this.addonCurrentHeat = c.func_74760_g("addonCurrentHeat");
        if (!c.func_74764_b("auraID")) {
            c.func_74768_a("auraID", this.auraID);
        }
        this.auraID = c.func_74762_e("auraID");
        if (!c.func_74764_b("outlineID")) {
            c.func_74768_a("outlineID", this.outlineID);
        }
        this.outlineID = c.func_74762_e("outlineID");
        if (!c.func_74764_b("DBCBaseFlightSpeed")) {
            c.func_74776_a("DBCBaseFlightSpeed", this.baseFlightSpeed);
        }
        this.baseFlightSpeed = c.func_74760_g("DBCBaseFlightSpeed");
        if (!c.func_74764_b("DBCDynamicFlightSpeed")) {
            c.func_74776_a("DBCDynamicFlightSpeed", this.dynamicFlightSpeed);
        }
        this.dynamicFlightSpeed = c.func_74760_g("DBCDynamicFlightSpeed");
        if (!c.func_74764_b("DBCSprintSpeed")) {
            c.func_74776_a("DBCSprintSpeed", this.sprintSpeed);
        }
        this.sprintSpeed = c.func_74760_g("DBCSprintSpeed");
        if (!c.func_74764_b("DBCFlightSpeedRelease")) {
            c.func_74768_a("DBCFlightSpeedRelease", this.flightSpeedRelease);
        }
        this.flightSpeedRelease = c.func_74762_e("DBCFlightSpeedRelease");
        if (!c.func_74764_b("DBCFlightEnabled")) {
            c.func_74757_a("DBCFlightEnabled", this.flightEnabled);
        }
        this.flightEnabled = c.func_74767_n("DBCFlightEnabled");
        if (!c.func_74764_b("DBCFlightGravity")) {
            c.func_74757_a("DBCFlightGravity", this.flightGravity);
        }
        this.flightGravity = c.func_74767_n("DBCFlightGravity");
        if (!c.func_74764_b("DBCIsFnPressed")) {
            c.func_74757_a("DBCIsFnPressed", this.isFnPressed);
        }
        this.isFnPressed = c.func_74767_n("DBCIsFnPressed");
    }

    @SideOnly(value=Side.CLIENT)
    public void loadClientSideData(NBTTagCompound c) {
        this.potaraFusionLevel = c.func_74771_c("potaraLevel");
        if (this.currentBonuses == null) {
            this.currentBonuses = new HashMap<String, PlayerBonus>();
        } else {
            this.currentBonuses.clear();
        }
        if (c.func_150297_b("addonBonus", 9)) {
            NBTTagList nbttaglist = c.func_150295_c("addonBonus", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                PlayerBonus bonus = PlayerBonus.readBonusData(nbttagcompound1);
                this.currentBonuses.put(bonus.name, bonus);
            }
        }
        this.currentCustomizedColors = new FormDisplay.BodyColor();
        if (c.func_150297_b("CustomFormColors", 10)) {
            this.currentCustomizedColors.readFromNBT(c.func_74775_l("CustomFormColors"));
        }
    }

    public void saveNBTData(boolean syncTracking) {
        NBTTagCompound nbt = this.saveFromNBT(this.player.getEntityData().func_74775_l(DBCPersisted));
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        this.addonFormID = formData.currentForm;
        this.addonFormLevel = formData.getCurrentLevel();
        this.auraID = formData.currentAura;
        nbt.func_74768_a("addonFormID", this.addonFormID);
        nbt.func_74776_a("addonFormLevel", this.addonFormLevel);
        nbt.func_74768_a("auraID", this.auraID);
        nbt.func_74768_a("outlineID", this.outlineID);
        this.player.getEntityData().func_74782_a(DBCPersisted, (NBTBase)nbt);
        if (syncTracking) {
            this.syncTracking();
        }
    }

    public void loadNBTData(boolean syncALL) {
        NBTTagCompound dbc = this.player.getEntityData().func_74775_l(DBCPersisted);
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(this.player);
        dbc.func_74768_a("addonFormID", formData.currentForm);
        dbc.func_74768_a("auraID", formData.currentAura);
        dbc.func_74776_a("addonFormLevel", formData.getCurrentLevel());
        this.loadFromNBT(dbc);
        if (syncALL) {
            this.syncTracking();
        }
    }

    public void loadCharging() {
        NBTTagCompound dbc = this.player.getEntityData().func_74775_l(DBCPersisted);
        this.Skills = dbc.func_74779_i("jrmcSSlts");
        this.Release = dbc.func_74771_c("jrmcRelease");
        this.isFnPressed = dbc.func_74767_n("DBCIsFnPressed");
    }

    public void syncTracking() {
        NBTTagCompound dataNeededOnClient = new NBTTagCompound();
        this.bonus.saveBonusNBT(dataNeededOnClient);
        PlayerEffect potara = (PlayerEffect)CustomEffectController.getInstance().getPlayerEffects(this.player).get(new EffectKey(12, DBCEffectController.DBC_EFFECT_INDEX));
        if (potara != null) {
            dataNeededOnClient.func_74774_a("potaraLevel", potara.level);
        } else {
            dataNeededOnClient.func_74774_a("potaraLevel", (byte)-1);
        }
        FormDisplay.BodyColor currentColors = this.getCurrentFormColorCustomization();
        if (currentColors != null) {
            NBTTagCompound colorCompound = new NBTTagCompound();
            currentColors.writeToNBT(colorCompound);
            dataNeededOnClient.func_74782_a("CustomFormColors", (NBTBase)colorCompound);
        }
        DBCPacketHandler.Instance.sendTracking(new PingPacket(this, dataNeededOnClient), (Entity)this.player);
    }

    public NBTTagCompound getRawCompound() {
        return this.player.getEntityData().func_74775_l(DBCPersisted);
    }

    @Override
    public boolean isForm(int dbcForm) {
        switch (dbcForm) {
            case 0: {
                return this.State == 0 && !this.isForm(31) && !this.isForm(41) && !this.isForm(24) && !this.isForm(21);
            }
            case 31: {
                return this.State2 > 0 && JRMCoreH.StusEfcts((int)5, (String)this.StatusEffects);
            }
            case 41: {
                return this.State2 > 0 && JRMCoreH.StusEfcts((int)19, (String)this.StatusEffects) && !JRMCoreH.StusEfcts((int)5, (String)this.StatusEffects);
            }
            case 40: {
                return this.isForm(41) && JGConfigUltraInstinct.CONFIG_UI_LEVELS >= this.State2 ? JGConfigUltraInstinct.CONFIG_UI_HAIR_WHITE[this.State2 - 1] : false;
            }
            case 24: {
                return JRMCoreH.StusEfcts((int)20, (String)this.StatusEffects);
            }
            case 21: {
                return JRMCoreH.StusEfcts((int)13, (String)this.StatusEffects);
            }
            case 25: {
                return JRMCoreH.StusEfcts((int)14, (String)this.StatusEffects);
            }
            case 26: {
                return JRMCoreH.StusEfcts((int)17, (String)this.StatusEffects);
            }
            case 27: {
                return JRMCoreH.StusEfcts((int)12, (String)this.StatusEffects);
            }
        }
        return false;
    }

    public boolean hasForm(int dbcForm) {
        if (dbcForm == 31) {
            return JRMCoreH.SklLvl((int)8) > 0;
        }
        if (dbcForm == 41 && dbcForm == 40) {
            return JRMCoreH.SklLvl((int)16) > 0;
        }
        if (dbcForm == 24) {
            return JRMCoreH.SklLvl((int)18) > 0;
        }
        if (dbcForm == 21) {
            return JRMCoreH.SklLvl((int)10) > 0;
        }
        int racialSkill = JRMCoreH.SklLvlX((int)this.Powertype, (String)this.RacialSkills) - 1;
        int godSkill = JRMCoreH.SklLvl((int)9);
        switch (this.Race) {
            case 0: {
                switch (dbcForm) {
                    case 1: {
                        return racialSkill >= 1;
                    }
                    case 2: {
                        return racialSkill >= 2;
                    }
                    case 3: {
                        return racialSkill >= 2 && godSkill >= 1;
                    }
                }
                return false;
            }
            case 1: 
            case 2: {
                switch (dbcForm) {
                    case 1: {
                        return racialSkill >= 1 && racialSkill < 4;
                    }
                    case 2: {
                        return racialSkill >= 2;
                    }
                    case 3: {
                        return racialSkill >= 3;
                    }
                    case 4: {
                        return racialSkill >= 4;
                    }
                    case 5: {
                        return racialSkill >= 5;
                    }
                    case 6: {
                        return racialSkill >= 6;
                    }
                    case 14: {
                        return racialSkill >= 7 && this.hasSSJ4 > 0 && this.hasTail();
                    }
                    case 9: {
                        return racialSkill >= 5 && godSkill >= 1;
                    }
                    case 10: {
                        return racialSkill >= 5 && godSkill >= 2;
                    }
                    case 15: {
                        return racialSkill >= 5 && godSkill >= 3;
                    }
                }
                return false;
            }
            case 3: {
                switch (dbcForm) {
                    case 1: {
                        return racialSkill >= 1;
                    }
                    case 2: {
                        return racialSkill >= 2;
                    }
                    case 3: {
                        return racialSkill >= 2 && godSkill >= 1;
                    }
                }
                return false;
            }
            case 4: {
                switch (dbcForm) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                    case 5: {
                        return racialSkill >= 3;
                    }
                    case 6: {
                        return racialSkill >= 6;
                    }
                    case 7: {
                        return racialSkill >= 6 && godSkill >= 1;
                    }
                }
                return false;
            }
            case 5: {
                switch (dbcForm) {
                    case 1: {
                        return racialSkill >= 2;
                    }
                    case 2: {
                        return racialSkill >= 3;
                    }
                    case 3: {
                        return racialSkill >= 5;
                    }
                    case 4: {
                        return racialSkill >= 5 && godSkill >= 1;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isDBCFormUnlocked(int formID) {
        return this.getUnlockedDBCFormsMap().containsKey(formID);
    }

    public HashMap<Integer, String> getUnlockedDBCFormsMap() {
        LinkedHashMap<Integer, String> dbcForms = new LinkedHashMap<Integer, String>();
        byte race = this.Race;
        int racialSkill = JRMCoreH.SklLvlX((int)1, (String)this.RacialSkills) - 1;
        int godSkill = JRMCoreH.SklLvl((int)9);
        if (race == 0) {
            if (racialSkill >= 1) {
                dbcForms.put(2, "\u00a73Buffed");
            }
            if (racialSkill >= 2) {
                dbcForms.put(1, "\u00a74Full Release");
            }
            if (racialSkill >= 2 && godSkill >= 1) {
                dbcForms.put(3, "\u00a7cGod");
            }
        } else if (race == 1 || race == 2) {
            if (racialSkill >= 1 && racialSkill < 4) {
                dbcForms.put(1, "\u00a7eSuper Saiyan");
            }
            if (racialSkill >= 4) {
                dbcForms.put(4, "\u00a7eSuper Saiyan (FP)");
            }
            if (racialSkill >= 2) {
                dbcForms.put(2, "\u00a7eSuper Saiyan G2");
            }
            if (racialSkill >= 3) {
                dbcForms.put(3, "\u00a7eSuper Saiyan G3");
            }
            if (racialSkill >= 5) {
                dbcForms.put(5, "\u00a7eSuper Saiyan 2");
            }
            if (racialSkill >= 6) {
                dbcForms.put(6, "\u00a7eSuper Saiyan 3");
            }
            if (racialSkill >= 7 && this.hasSSJ4 > 0 && this.hasTail()) {
                dbcForms.put(14, "\u00a74Super Saiyan 4");
            }
            if (racialSkill >= 5 && godSkill >= 1) {
                dbcForms.put(9, "\u00a7cSuper Saiyan God");
            }
            if (racialSkill >= 5 && godSkill >= 2) {
                dbcForms.put(10, !this.isForm(26) ? "\u00a7bSuper Saiyan Blue" : "\u00a75Super Saiyan Ros\u00e9");
            }
            if (racialSkill >= 5 && godSkill >= 3) {
                dbcForms.put(15, !this.isForm(26) ? "\u00a71Super Saiyan Blue Evo" : "\u00a7dSuper Saiyan Ros\u00e9 Evo");
            }
        } else if (race == 3) {
            if (racialSkill >= 1) {
                dbcForms.put(2, "\u00a72Giant");
            }
            if (racialSkill >= 2) {
                dbcForms.put(1, "\u00a7aFull Release");
            }
            if (racialSkill >= 2 && godSkill >= 1) {
                dbcForms.put(3, "\u00a7cGod");
            }
        } else if (race == 4) {
            dbcForms.put(1, "\u00a75First Form");
            dbcForms.put(2, "\u00a75Second Form");
            dbcForms.put(3, "\u00a75Third Form");
            dbcForms.put(4, "\u00a75Final Form");
            if (racialSkill >= 3) {
                dbcForms.put(5, "\u00a75Super Form");
            }
            if (racialSkill >= 6) {
                dbcForms.put(6, "\u00a76Ultimate Form");
            }
            if (racialSkill >= 6 && godSkill >= 1) {
                dbcForms.put(7, "\u00a7cGod");
            }
        } else if (race == 5) {
            if (racialSkill >= 2) {
                dbcForms.put(1, "\u00a78Evil");
            }
            if (racialSkill >= 3) {
                dbcForms.put(2, "\u00a75Full Power");
            }
            if (racialSkill >= 5) {
                dbcForms.put(3, "\u00a7dPure");
            }
            if (racialSkill >= 5 && godSkill >= 1) {
                dbcForms.put(4, "\u00a7cGod");
            }
        }
        if (JRMCoreH.SklLvl((int)10) > 0) {
            dbcForms.put(21, "Mystic");
        }
        int kaiokenSkill = JRMCoreH.SklLvl((int)8);
        for (int i = 0; i < 6; ++i) {
            if (kaiokenSkill < i + 1) continue;
            dbcForms.put(31 + i, "\u00a7cKaioken " + JRMCoreH.TransKaiNms[i + 1]);
        }
        int uiSkill = JRMCoreH.SklLvl((int)16);
        for (int i = 0; i < JGConfigUltraInstinct.CONFIG_UI_LEVELS; ++i) {
            if (uiSkill < i + 1 || JGConfigUltraInstinct.CONFIG_UI_SKIP[i]) continue;
            dbcForms.put(41 + i, "\u00a77" + DBCUtils.CONFIG_UI_NAME[i]);
        }
        if (JRMCoreH.SklLvl((int)18) > 0) {
            dbcForms.put(24, "\u00a7dGod of Destruction");
        }
        return dbcForms;
    }

    public boolean containsSE(int id) {
        return JRMCoreH.StusEfcts((int)id, (String)this.StatusEffects);
    }

    public String setSE(int id, boolean bo) {
        return JRMCoreH.StusEfcts((int)id, (String)this.StatusEffects, (NBTTagCompound)this.getRawCompound(), (boolean)bo);
    }

    public String setForm(int dbcForm, boolean on) {
        switch (dbcForm) {
            case 31: {
                this.StatusEffects = this.setSE(5, on);
                this.State2 = (byte)(on ? 1 : 0);
                this.getRawCompound().func_74774_a("jrmcState2", this.State2);
                break;
            }
            case 41: {
                this.StatusEffects = this.setSE(19, on);
                this.State2 = (byte)(on ? 1 : 0);
                this.getRawCompound().func_74774_a("jrmcState2", this.State2);
                break;
            }
            case 24: {
                this.StatusEffects = this.setSE(20, on);
                break;
            }
            case 21: {
                this.StatusEffects = this.setSE(13, on);
                break;
            }
            case 25: {
                this.StatusEffects = this.setSE(14, on);
                break;
            }
            case 26: {
                this.StatusEffects = this.setSE(17, on);
                break;
            }
            case 27: {
                this.StatusEffects = this.setSE(12, on);
            }
        }
        return this.StatusEffects;
    }

    public boolean settingOn(int id) {
        return JRMCoreH.PlyrSettingsB((NBTTagCompound)this.getRawCompound(), (int)id);
    }

    public boolean settingIsValue(int id, int value) {
        return JRMCoreH.PlyrSettingsI((NBTTagCompound)this.getRawCompound(), (int)id, (int)value);
    }

    public void setSetting(int id, int value) {
        JRMCoreH.PlyrSettingsSet((NBTTagCompound)this.getRawCompound(), (int)id, (int)value);
    }

    public boolean formSettingOn(int dbcForm) {
        switch (dbcForm) {
            case 2: {
                return this.settingIsValue(1, -1);
            }
            case 5: {
                return this.settingIsValue(1, 0);
            }
            case 9: {
                return this.settingIsValue(1, 1);
            }
            case 10: {
                return this.settingIsValue(1, 2);
            }
            case 14: {
                return this.settingIsValue(1, 3);
            }
            case 31: {
                return this.settingOn(0);
            }
            case 41: {
                return this.settingOn(11);
            }
            case 24: {
                return this.settingOn(16);
            }
            case 21: {
                return this.settingOn(6);
            }
        }
        return false;
    }

    @Override
    public boolean isAuraOn() {
        return this.isTransforming() || this.containsSE(3) || this.containsSE(4) || this.containsSE(5) || this.containsSE(7);
    }

    @Override
    public boolean isFusionSpectator() {
        return this.stats.isFusionSpectator();
    }

    @Override
    public void useStencilBuffer(boolean use) {
        this.useStencilBuffer = use;
    }

    @Override
    public boolean isTransforming() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.player == Minecraft.func_71410_x().field_71439_g && TransformController.ascending) {
            return true;
        }
        return this.containsSE(1);
    }

    @Override
    public boolean isChargingKi() {
        return this.containsSE(4);
    }

    public void setTurboState(boolean on) {
        this.StatusEffects = this.setSE(3, on);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            DBCPacketHandler.Instance.sendToPlayer(new TurboPacket(on), (EntityPlayerMP)this.player);
        } else {
            DBCKiTech.turbo = on;
        }
    }

    @Override
    public boolean isInKaioken() {
        return this.isForm(31);
    }

    @Override
    public int getDBCColor() {
        return JRMCoreHDBC.getPlayerColor2((int)2, (int)JRMCoreH.Algnmnt_rc((int)this.Alignment), (int)1, (int)this.Race, (int)this.State, (boolean)this.isForm(26), (boolean)this.isForm(25), (boolean)this.isForm(41), (boolean)this.isForm(24));
    }

    public Aura getToggledAura() {
        if (!this.isAuraOn() && !this.isTransforming()) {
            return null;
        }
        return this.getAura();
    }

    public boolean hasTail() {
        if (DBCRace.isSaiyan(this.Race)) {
            return this.Tail == -1 || this.Tail == 0 || this.Tail == 1;
        }
        return this.Race == 4;
    }

    public Aura getAura() {
        Form form = this.getForm();
        Aura aura = null;
        if (form != null && form.display.hasAura()) {
            aura = form.display.getAur();
        } else if (aura == null) {
            aura = (Aura)AuraController.Instance.get(this.auraID);
        }
        if (aura != null) {
            if (!(aura.display.overrideDBCAura || this.isForm(0) || this.isForm(31) && aura.display.hasKaiokenAura && this.State == 0)) {
                return null;
            }
            return aura;
        }
        return null;
    }

    public Form getForm() {
        Form form = (Form)FormController.getInstance().get(this.addonFormID);
        if (form != null) {
            Form majin;
            Form legendary;
            Form divine;
            Form fusionForm = (Form)FormController.getInstance().get(form.stackable.fusionID);
            if (fusionForm != null && this.stats.isFused()) {
                form = fusionForm;
            }
            if (form.stackable.divineID != -1 && this.isForm(26) && (divine = (Form)FormController.getInstance().get(form.stackable.divineID)) != null) {
                return divine;
            }
            if (form.stackable.legendaryID != -1 && this.isForm(25) && (legendary = (Form)FormController.getInstance().get(form.stackable.legendaryID)) != null) {
                return legendary;
            }
            if (form.stackable.majinID != -1 && this.isForm(27) && (majin = (Form)FormController.getInstance().get(form.stackable.majinID)) != null) {
                return majin;
            }
        }
        return form;
    }

    public Outline getOutline() {
        IAura formAura;
        OutlineController OC = OutlineController.getInstance();
        Aura aura = this.getToggledAura();
        if (aura != null && OC.has(aura.display.outlineID)) {
            return (Outline)OC.get(aura.display.outlineID);
        }
        Form form = this.getForm();
        if (form != null && OC.has(form.display.outlineID)) {
            return (Outline)OC.get(form.display.outlineID);
        }
        IAura iAura = formAura = form != null ? form.display.getAura() : null;
        if (formAura != null) {
            aura = (Aura)formAura;
            if (aura.display.outlineAlwaysOn && OC.has(aura.display.outlineID)) {
                return (Outline)OC.get(aura.display.outlineID);
            }
        }
        if ((aura = (Aura)AuraController.Instance.get(this.auraID)) != null && aura.display.outlineAlwaysOn && OC.has(aura.display.outlineID)) {
            return (Outline)OC.get(aura.display.outlineID);
        }
        return (Outline)OC.get(this.outlineID);
    }

    public void setOutline(IOutline outline) {
        int id = outline != null ? outline.getID() : -1;
        this.setOutline(id);
    }

    public void setOutline(int outlineID) {
        this.getRawCompound().func_74768_a("outlineID", outlineID);
    }

    public void setFlight(boolean flightOn) {
        DBCPacketHandler.Instance.sendToPlayer(new DBCSetFlight(flightOn), (EntityPlayerMP)this.player);
    }

    public float getBaseFlightSpeed() {
        float formSpeed = 1.0f;
        Form form = this.getForm();
        if (form != null) {
            formSpeed = form.mastery.movementSpeed * form.mastery.calculateMulti("movementspeed", this.addonFormLevel);
        }
        return this.baseFlightSpeed * formSpeed;
    }

    public float getDynamicFlightSpeed() {
        float formSpeed = 1.0f;
        Form form = this.getForm();
        if (form != null) {
            formSpeed = form.mastery.movementSpeed * form.mastery.calculateMulti("movementspeed", this.addonFormLevel);
        }
        return this.dynamicFlightSpeed * formSpeed;
    }

    public float getSprintSpeed() {
        float formSpeed = 1.0f;
        Form form = this.getForm();
        if (form != null) {
            formSpeed = form.mastery.movementSpeed * form.mastery.calculateMulti("movementspeed", this.addonFormLevel);
        }
        return this.sprintSpeed * formSpeed;
    }

    public void fuseWith(DBCData spectator, float time) {
        if (spectator == null || this.player == null) {
            return;
        }
        if (spectator.player == this.player) {
            throw new CustomNPCsException("Tried to fuse the player with themselves", new Object[0]);
        }
        String controllerName = this.player.func_70005_c_();
        String spectatorName = spectator.player.func_70005_c_();
        NBTTagCompound controllerTag = this.getRawCompound();
        NBTTagCompound spectatorTag = spectator.getRawCompound();
        String fusionString = String.format("%s,%s,%d", controllerName, spectatorName, (int)(time *= 12.0f));
        controllerTag.func_74778_a("jrmcFuzion", fusionString);
        spectatorTag.func_74778_a("jrmcFuzion", fusionString);
        this.setSE(10, true);
        spectator.setSE(11, true);
        JRMCoreH.PlyrSettingsRem((EntityPlayer)this.player, (int)4);
        JRMCoreH.PlyrSettingsRem((EntityPlayer)spectator.player, (int)4);
        controllerTag.func_74774_a("jrmcState2", (byte)0);
        spectatorTag.func_74774_a("jrmcState2", (byte)0);
        spectator.setSE(3, false);
        spectator.setSE(4, false);
        spectator.setSE(5, false);
        this.stats.restoreHealthPercent(100.0f);
        spectator.stats.restoreHealthPercent(100.0f);
        this.stats.restoreKiPercent(100.0f);
        spectator.stats.restoreKiPercent(100.0f);
    }

    public float getFusionMastery(DBCData controller, DBCData spectator) {
        float mastery = 0.0f;
        Form form = controller.getForm();
        if (form != null) {
            mastery = controller.getDBCInfo().getFormLevel(form.id);
            if (spectator.getDBCInfo().hasFormUnlocked(form.id)) {
                mastery = ValueUtil.clamp((float)(mastery + spectator.getDBCInfo().getFormLevel(form.id)), (float)0.0f, (float)form.mastery.getMaxLevel());
            }
        }
        return mastery;
    }

    public PlayerDBCInfo getDBCInfo() {
        return PlayerDataUtil.getDBCInfo(this.player);
    }

    @Override
    public EntityAura getAuraEntity() {
        return this.auraEntity;
    }

    @Override
    public void setAuraEntity(EntityAura aura) {
        this.auraEntity = aura;
    }

    @Override
    public Entity getEntity() {
        return this.player;
    }

    @Override
    public int getAuraColor() {
        return this.AuraColor > 0 ? this.AuraColor : JRMCoreH.Algnmnt_rc((int)this.Alignment);
    }

    @Override
    public byte getRace() {
        return this.Race;
    }

    @Override
    public int getFormID() {
        return this.addonFormID;
    }

    @Override
    public byte getRelease() {
        return this.Release;
    }

    @Override
    public byte getState() {
        return this.State;
    }

    @Override
    public byte getState2() {
        return this.State2;
    }

    public void setLockOnTarget(EntityLivingBase lockOnTarget) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            DBCUpdateLockOn packet = lockOnTarget == null ? new DBCUpdateLockOn() : new DBCUpdateLockOn(lockOnTarget.func_145782_y());
            DBCPacketHandler.Instance.sendToPlayer(packet, (EntityPlayerMP)this.player);
            return;
        }
        if (this.side == Side.CLIENT) {
            if (this.player == Minecraft.func_71410_x().field_71439_g) {
                DBCUpdateLockOn.setLockOnTarget(lockOnTarget);
            }
            return;
        }
    }

    @Override
    public HashMap getDBCAuras(boolean secondary) {
        return null;
    }

    @Override
    public List<EntityCusPar> getParticles() {
        return this.particleRenderQueue;
    }

    @Override
    public int getActiveAuraColor() {
        return this.activeAuraColor;
    }

    @Override
    public void setActiveAuraColor(int color) {
        this.activeAuraColor = color;
    }

    public int getUsedMind() {
        int[][] sklsMR;
        String[] skls;
        String[] cSkls;
        int[][] rSklsMR = null;
        int[][] cSklsMR = null;
        if (JRMCoreH.isPowerTypeChakra((int)this.Powertype)) {
            cSkls = JRMCoreH.ncCSkls;
            cSklsMR = JRMCoreH.NCRacialSkillMindCost;
            skls = JRMCoreH.NCSkillIDs;
            sklsMR = JRMCoreH.NCSkillMindCost;
        } else {
            rSklsMR = JRMCoreH.DBCRacialSkillMindCost;
            cSkls = JRMCoreH.vlblCSkls;
            skls = JRMCoreH.DBCSkillsIDs;
            sklsMR = JRMCoreH.DBCSkillMindCost;
        }
        int mindSpentOnSkills = JRMCoreH.skillSlot_SpentMindRequirement((String[])this.Skills.split(","), (String[])skls, (int[][])sklsMR);
        int mindSpentOnRacialForms = JRMCoreH.skillSlot_SpentMindRequirement_X((String)this.RacialSkills, (int)this.Race, (int[][])rSklsMR);
        int raceStuff = JRMCoreH.skillSlot_SpentMindRequirement((String)this.getRawCompound().func_74779_i("jrmcSSltY"), (String[])cSkls, (int[][])cSklsMR);
        int addonTakenAwayMind = this.calculateMindBonuses();
        return mindSpentOnSkills + mindSpentOnRacialForms + raceStuff - addonTakenAwayMind;
    }

    public int calculateMindBonuses() {
        int mindBonus = 0;
        PlayerDBCInfo formData = this.getDBCInfo();
        FormController formController = FormController.getInstance();
        for (int formID : formData.unlockedForms) {
            IForm form = formController.get(formID);
            if (form == null) continue;
            mindBonus -= form.getMindRequirement();
        }
        return mindBonus;
    }

    public int getAvailableMind() {
        return this.MND - this.getUsedMind();
    }

    public FormDisplay.BodyColor getCurrentFormColorCustomization() {
        if (this.side.isClient()) {
            return this.currentCustomizedColors;
        }
        Form form = this.getForm();
        if (form == null || !form.display.isCustomizable()) {
            return null;
        }
        PlayerDBCInfo info = this.getDBCInfo();
        return info.configuredFormColors.get(form.id);
    }
}

