/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.config;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import kamkeel.npcdbc.client.ClientCache;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigDBCGeneral {
    public static Configuration config;
    public static final String NPC = "NPC";
    private static final String FORM_REMOVAL = "FORM REMOVAL";
    public static final String CHARACTER_RESET = "CHARACTER RESET";
    public static final String DISCORD_BUTTON = "DISCORD BUTTON";
    public static boolean DISPLAY_BY_DEFAULT;
    public static boolean STATS_BY_DEFAULT;
    public static boolean AURAS_CLEAR_ON_RESET;
    public static boolean FORMS_CLEAR_ON_RESET;
    public static boolean FORM_MASTERIES_CLEAR_ON_RESET;
    public static boolean FORM_MASTERIES_CLEAR_ON_REMOVE;
    public static boolean ALLOW_DBC_DAMAGE_RESISTANCE;
    private static final String defaultDiscordURL = "https://discord.com/invite/pQqRTvFeJ5";
    public static String discordURL;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            DISPLAY_BY_DEFAULT = config.get(NPC, "DBC Display Enabled by Default", false).getBoolean(false);
            STATS_BY_DEFAULT = config.get(NPC, "DBC Stats Enabled by Default", false).getBoolean(false);
            ALLOW_DBC_DAMAGE_RESISTANCE = config.get(NPC, "Should the melee resistance on NPCs work against DBC Damage?", true, "Turning this off could break Ki Resistance on NPCs").getBoolean(true);
            AURAS_CLEAR_ON_RESET = config.get(CHARACTER_RESET, "Should Custom Auras be removed on character reset?", true).getBoolean(true);
            FORMS_CLEAR_ON_RESET = config.get(CHARACTER_RESET, "Should Custom Forms be removed on character reset?", true).getBoolean(true);
            FORM_MASTERIES_CLEAR_ON_RESET = config.get(CHARACTER_RESET, "Should CF Masteries be removed on character reset?", true).getBoolean(true);
            FORM_MASTERIES_CLEAR_ON_REMOVE = config.get(FORM_REMOVAL, "Should custom form mastery be removed on form removal unless specified otherwise in a script?", true).getBoolean(true);
            discordURL = config.getString("URL", DISCORD_BUTTON, defaultDiscordURL, "Discord URL for the button in the stat sheet. If it's empty it will show the Addon's discord");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"DBC Addon has had a problem loading its general configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static String getDiscordURL() {
        String cachedDiscordURL;
        String string = cachedDiscordURL = FMLCommonHandler.instance().getEffectiveSide().isClient() ? ClientCache.discordURL : discordURL;
        if (cachedDiscordURL == null || cachedDiscordURL.trim().isEmpty()) {
            return defaultDiscordURL;
        }
        return cachedDiscordURL;
    }

    static {
        DISPLAY_BY_DEFAULT = false;
        STATS_BY_DEFAULT = false;
        AURAS_CLEAR_ON_RESET = true;
        FORMS_CLEAR_ON_RESET = true;
        FORM_MASTERIES_CLEAR_ON_RESET = true;
        FORM_MASTERIES_CLEAR_ON_REMOVE = true;
        ALLOW_DBC_DAMAGE_RESISTANCE = true;
        discordURL = null;
    }
}

