/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.sound;

import kamkeel.npcdbc.client.gui.global.auras.SubGuiAuraDisplay;
import kamkeel.npcdbc.client.sound.ClientSound;
import kamkeel.npcdbc.client.sound.SoundHandler;
import kamkeel.npcdbc.config.ConfigDBCClient;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.data.IAuraData;
import kamkeel.npcdbc.data.SoundSource;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.npc.DBCDisplay;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.entity.EntityNPCInterface;

public class AuraSound
extends ClientSound {
    private final Aura aura;
    public boolean isKaiokenSound = false;
    public boolean isGUIAura;
    public boolean isVanillaAura;
    public IAuraData data;

    public AuraSound(Aura aura, SoundSource soundSource) {
        super(soundSource);
        this.field_147662_b = 0.01f;
        soundSource.maxVolume = 0.5f;
        soundSource.fadeIn = true;
        soundSource.range = 32.0f;
        this.aura = aura;
        soundSource.onlyOneCanExist = true;
        soundSource.fadeFactor = 0.02f;
        soundSource.key = soundSource.key + ":AURA";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!ConfigDBCClient.RevampAura) {
            Aura aura = null;
            boolean isInKaioken = false;
            if (this.entity instanceof EntityNPCInterface) {
                DBCDisplay display = ((INPCDisplay)((EntityNPCInterface)this.entity).display).getDBCDisplay();
                aura = display.getToggledAura();
            } else if (this.entity instanceof EntityPlayer) {
                DBCData dbcData = DBCData.get((EntityPlayer)this.entity);
                aura = dbcData.getToggledAura();
                isInKaioken = dbcData.isForm(31);
            }
            if (this.isVanillaAura) {
                if (!this.data.isAuraOn()) {
                    this.soundSource.fadeOut = true;
                }
            } else if (!this.isGUIAura) {
                if (aura == null && !this.isVanillaAura) {
                    this.soundSource.fadeFactor = this.isGUIAura ? 0.075f : this.soundSource.fadeFactor;
                    this.soundSource.fadeOut = true;
                } else if (aura.id != this.aura.id || !isInKaioken && this.isKaiokenSound) {
                    this.soundSource.fadeFactor = this.isGUIAura ? 0.075f : 0.1f;
                    this.soundSource.fadeOut = true;
                }
            }
        }
    }

    public float func_147649_g() {
        if (this.isGUIAura) {
            return (float)Minecraft.func_71410_x().field_71439_g.field_70165_t;
        }
        return this.field_147660_d;
    }

    public float func_147654_h() {
        if (this.isGUIAura) {
            return (float)Minecraft.func_71410_x().field_71439_g.field_70163_u;
        }
        return this.field_147661_e;
    }

    public float func_147651_i() {
        if (this.isGUIAura) {
            return (float)Minecraft.func_71410_x().field_71439_g.field_70161_v;
        }
        return this.field_147658_f;
    }

    public static void play(Entity entity, Aura aura, IAuraData data) {
        String secondSound;
        String string;
        if (entity == null || aura == null || SubGuiAuraDisplay.useGUIAura) {
            return;
        }
        boolean isTransforming = false;
        if (entity instanceof EntityPlayer) {
            DBCData dbcData = DBCData.get((EntityPlayer)entity);
            isTransforming = dbcData.isTransforming();
        } else if (entity instanceof EntityNPCInterface) {
            DBCDisplay display = ((INPCDisplay)((EntityNPCInterface)entity).display).getDBCDisplay();
            isTransforming = display.isTransforming;
        }
        String sound = aura.display.getFinalSound(aura.display.type);
        if (aura.hasSecondaryAura()) {
            EnumAuraTypes3D cfr_ignored_0 = aura.getSecondaryAur().display.type;
            string = aura.getSecondaryAur().display.getFinalSound(EnumAuraTypes3D.Base);
        } else {
            string = secondSound = null;
        }
        if (!SoundHandler.isPlayingSound(entity, sound)) {
            AuraSound auraSound = new AuraSound(aura, new SoundSource(sound, entity));
            if (isTransforming) {
                auraSound.setVolume(0.2f);
            }
            if (aura.id == -1) {
                auraSound.isVanillaAura = true;
            }
            auraSound.data = data;
            auraSound.setRepeat(true).play(false);
        }
        if (secondSound != null && !SoundHandler.isPlayingSound(entity, secondSound)) {
            AuraSound secondarySound = new AuraSound(aura, new SoundSource(secondSound, entity));
            if (isTransforming) {
                secondarySound.setVolume(0.2f);
            }
            secondarySound.data = data;
            secondarySound.setRepeat(true).play(false);
        }
    }
}

