/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.playertab.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.Loader;
import io.github.cruciblemc.necrotempus.NecroTempusConfig;
import io.github.cruciblemc.necrotempus.api.playertab.PlayerTab;
import io.github.cruciblemc.necrotempus.api.playertab.TabCell;
import io.github.cruciblemc.necrotempus.modules.features.playertab.client.ClientPlayerTabManager;
import io.github.cruciblemc.necrotempus.modules.features.playertab.client.DefaultPlayerTab;
import io.github.cruciblemc.necrotempus.utils.SkinProvider;
import io.github.cruciblemc.necrotempus.utils.TextureUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lain.mods.skinport.init.forge.asm.Hooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PlayerTabGui
extends Gui {
    private final Minecraft minecraft;
    private boolean drawPlayerHeads = true;
    private IChatComponent footer;
    private IChatComponent header;
    private long lastTimeOpened;
    private boolean isBeingRendered;
    ScoreObjective worldScoreboardObjective;
    private static PlayerTabGui instance;
    private static final HashSet<String> DOWNLOADING_SKINS;
    private static SkinProvider skinProvider;
    private static Constructor<MinecraftProfileTexture> constructor;

    public static PlayerTabGui getInstance() {
        return instance != null ? instance : new PlayerTabGui();
    }

    public PlayerTabGui() {
        instance = this;
        this.minecraft = Minecraft.func_71410_x();
    }

    public boolean shouldRender() {
        return this.minecraft.field_71474_y.field_74321_H.func_151470_d() && (!this.minecraft.func_71387_A() || this.worldScoreboardObjective != null);
    }

    public void render(int width) {
        PlayerTab playerTab = ClientPlayerTabManager.getPlayerTab();
        boolean def = false;
        if (playerTab == null) {
            playerTab = DefaultPlayerTab.getInstance();
            def = true;
        }
        this.header = playerTab.getHeader();
        this.footer = playerTab.getFooter();
        this.drawPlayerHeads = playerTab.isDrawPlayerHeads();
        if (this.drawPlayerHeads && !NecroTempusConfig.drawPlayersHeads) {
            this.drawPlayerHeads = false;
        }
        if (!def && playerTab.getCellList().isEmpty()) {
            playerTab = DefaultPlayerTab.getInstance();
        }
        this.drawPlayerList(width, playerTab.getCellList());
    }

    public void drawPlayerList(int width, List<TabCell> cells) {
        int cellsCount;
        this.minecraft.field_71424_I.func_76320_a("necroTempusPlayerTab");
        if (cells.size() > 80) {
            cells = cells.subList(0, 80);
        }
        Scoreboard worldScoreboard = this.minecraft.field_71441_e.func_96441_U();
        this.worldScoreboardObjective = worldScoreboard.func_96539_a(0);
        int[] maxWidths = this.calculateMaxWidths(cells, worldScoreboard, this.worldScoreboardObjective);
        int maxTextWidth = maxWidths[0];
        int maxScoreboardScoreWidth = maxWidths[1];
        int lastColumnCellCount = cellsCount = cells.size();
        int columnCount = 1;
        while (lastColumnCellCount > 20) {
            lastColumnCellCount = (cellsCount + ++columnCount - 1) / columnCount;
        }
        int maxCellSize = Math.min(columnCount * ((this.drawPlayerHeads ? 9 : 0) + maxTextWidth + maxScoreboardScoreWidth + 14), width - 50) / columnCount;
        int maxContainerWidth = maxCellSize * columnCount + (columnCount - 1) * 5;
        int startCellXDrawPosition = width / 2 - maxContainerWidth / 2;
        int currentYDrawPosition = 10;
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList<String> footerList = new ArrayList<String>();
        maxContainerWidth = this.loadExtraTextElements(maxContainerWidth, width, this.header, headerList);
        maxContainerWidth = this.loadExtraTextElements(maxContainerWidth, width, this.footer, footerList);
        this.minecraft.field_71424_I.func_76320_a("drawHeader");
        currentYDrawPosition = this.drawHeaderElement(width, maxContainerWidth, currentYDrawPosition, headerList);
        this.minecraft.field_71424_I.func_76319_b();
        this.minecraft.field_71424_I.func_76320_a("drawBackground");
        this.drawBackground(width, lastColumnCellCount, maxContainerWidth, currentYDrawPosition);
        this.minecraft.field_71424_I.func_76319_b();
        this.minecraft.field_71424_I.func_76320_a("drawTabCells");
        this.drawTabCells(cells, maxTextWidth, maxScoreboardScoreWidth, cellsCount, lastColumnCellCount, maxCellSize, startCellXDrawPosition, currentYDrawPosition);
        this.minecraft.field_71424_I.func_76319_b();
        this.minecraft.field_71424_I.func_76320_a("drawFooter");
        currentYDrawPosition = this.drawFooterElement(width, lastColumnCellCount, maxContainerWidth, currentYDrawPosition, footerList);
        this.minecraft.field_71424_I.func_76319_b();
        this.minecraft.field_71424_I.func_76319_b();
    }

    public int[] calculateMaxWidths(List<TabCell> cells, Scoreboard scoreboard, ScoreObjective scoreObjective) {
        int maxTextWidth = 0;
        int maxScoreboardScoreWidth = 0;
        for (TabCell cell : cells) {
            maxTextWidth = Math.max(this.minecraft.field_71466_p.func_78256_a(cell.getDisplayName().func_150254_d()) + (NecroTempusConfig.drawNumberedPing ? 36 : (NecroTempusConfig.extraPaddingBars ? 36 : 0)), maxTextWidth);
            if (scoreObjective == null) continue;
            if (scoreObjective.func_96680_c() != IScoreObjectiveCriteria.field_96638_f) {
                if (cell.getDisplayName() == null || cell.getLinkedUserName().isEmpty()) continue;
                Score score = scoreboard.func_96529_a(cell.getLinkedUserName(), scoreObjective);
                maxScoreboardScoreWidth = Math.max(this.minecraft.field_71466_p.func_78256_a(" " + score.func_96652_c()), maxScoreboardScoreWidth);
                continue;
            }
            maxScoreboardScoreWidth = 90;
        }
        return new int[]{maxTextWidth, maxScoreboardScoreWidth};
    }

    public int loadExtraTextElements(int currentMaxSize, int width, IChatComponent component, List<String> target) {
        int maxSize = currentMaxSize;
        if (component != null) {
            target.addAll(this.minecraft.field_71466_p.func_78271_c(component.func_150254_d(), width - 50));
            for (String text : target) {
                maxSize = Math.max(maxSize, this.minecraft.field_71466_p.func_78256_a(text));
            }
        }
        return maxSize;
    }

    private int drawExtraElement(int width, int maxContainerWidth, int currentYDrawPosition, List<String> elements, int minX, int minY) {
        int maxX = width / 2 + maxContainerWidth / 2 + 1;
        int maxY = currentYDrawPosition + elements.size() * this.minecraft.field_71466_p.field_78288_b;
        GL11.glPushMatrix();
        PlayerTabGui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)Integer.MIN_VALUE);
        GL11.glPopMatrix();
        for (String line : elements) {
            int lineWidth = this.minecraft.field_71466_p.func_78256_a(line);
            int x = width / 2 - lineWidth / 2;
            this.minecraft.field_71466_p.func_78261_a(line, x, currentYDrawPosition, -1);
            currentYDrawPosition += this.minecraft.field_71466_p.field_78288_b;
        }
        return currentYDrawPosition;
    }

    private int drawHeaderElement(int width, int maxContainerWidth, int currentYDrawPosition, List<String> headerList) {
        if (!headerList.isEmpty()) {
            int minX = width / 2 - maxContainerWidth / 2 - 1;
            int minY = currentYDrawPosition - 1;
            currentYDrawPosition = this.drawExtraElement(width, maxContainerWidth, currentYDrawPosition, headerList, minX, minY);
            ++currentYDrawPosition;
        }
        return currentYDrawPosition;
    }

    private int drawFooterElement(int width, int lastColumnCellCount, int maxContainerWidth, int currentYDrawPosition, List<String> footerList) {
        if (!footerList.isEmpty()) {
            int minX = width / 2 - maxContainerWidth / 2 - 1;
            int minY = (currentYDrawPosition += lastColumnCellCount * 9 + 1) - 1;
            this.drawExtraElement(width, maxContainerWidth, currentYDrawPosition, footerList, minX, minY);
        }
        return currentYDrawPosition;
    }

    private void drawTabCells(List<TabCell> cells, int maxTextWidth, int maxScoreboardScoreWidth, int cellsCount, int lastColumnCellCount, int maxCellSize, int startCellXDrawPosition, int currentYDrawPosition) {
        for (int currentCell = 0; currentCell < cellsCount; ++currentCell) {
            int textEndX;
            int scoreboardEndX;
            this.minecraft.field_71424_I.func_76320_a("cell$" + currentCell);
            int cellCount = currentCell / lastColumnCellCount;
            int leftCellCount = currentCell % lastColumnCellCount;
            int minX = startCellXDrawPosition + cellCount * maxCellSize + cellCount * 5;
            int minY = currentYDrawPosition + leftCellCount * 9;
            GL11.glPushMatrix();
            this.minecraft.field_71424_I.func_76320_a("cellBackground");
            PlayerTabGui.func_73734_a((int)minX, (int)minY, (int)(minX + maxCellSize), (int)(minY + 8), (int)0x20FFFFFF);
            this.minecraft.field_71424_I.func_76319_b();
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (cellCount >= cells.size()) continue;
            TabCell cell = this.enforceDisplayName(cells.get(currentCell));
            this.minecraft.field_71424_I.func_76320_a("drawPlayerHead");
            if (this.drawPlayerHeads) {
                minX = this.drawPlayerHead(minX, minY, cell);
            }
            this.minecraft.field_71424_I.func_76319_b();
            this.minecraft.field_71424_I.func_76320_a("playerName");
            this.minecraft.field_71466_p.func_78261_a(cell.getDisplayName().func_150254_d(), minX, minY, -1);
            this.minecraft.field_71424_I.func_76319_b();
            this.minecraft.field_71424_I.func_76320_a("drawScoreboardValues");
            if (cell.isDisplayScore() && (scoreboardEndX = (textEndX = minX + maxTextWidth + 1) + maxScoreboardScoreWidth) - textEndX > 5) {
                this.drawScoreboardValues(this.worldScoreboardObjective, minY, scoreboardEndX, cell);
            }
            this.minecraft.field_71424_I.func_76319_b();
            this.minecraft.field_71424_I.func_76320_a("drawPing");
            this.drawPing(maxCellSize, minX - (this.drawPlayerHeads ? 9 : 0), minY, cell);
            this.minecraft.field_71424_I.func_76319_b();
            this.minecraft.field_71424_I.func_76319_b();
        }
    }

    private TabCell enforceDisplayName(TabCell cell) {
        if (cell.getDisplayName().func_150260_c().isEmpty() && cell.getLinkedUserName() != null) {
            cell.setDisplayName((IChatComponent)new ChatComponentText(PlayerTabGui.getFormattedPlayerName(cell.getLinkedUserName(), this.minecraft)));
        }
        return cell;
    }

    private int drawPlayerHead(int minX, int minY, TabCell cell) {
        ResourceLocation texture = this.getPlayerSkin(cell.getSkullProfile());
        float height = 32.0f;
        try {
            height = TextureUtils.getBufferedImageFromResource((ResourceLocation)texture).getData().getBounds().height;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.minecraft.func_110434_K().func_110577_a(texture);
        GL11.glPushMatrix();
        PlayerTabGui.func_152125_a((int)minX, (int)minY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)height);
        GL11.glPopMatrix();
        return minX += 9;
    }

    private void drawBackground(int width, int lastColumnCellCount, int maxContainerWidth, int currentYDrawPosition) {
        int minX = width / 2 - maxContainerWidth / 2 - 1;
        int minY = currentYDrawPosition - 1;
        int maxX = width / 2 + maxContainerWidth / 2 + 1;
        int maxY = currentYDrawPosition + lastColumnCellCount * 9;
        GL11.glPushMatrix();
        PlayerTabGui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)Integer.MIN_VALUE);
        GL11.glPopMatrix();
    }

    private void drawPing(int maxCellSize, int minX, int minY, TabCell tabCell) {
        int pingStatusIcon;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int n = tabCell.getPlayerPing() < 0 ? 5 : (tabCell.getPlayerPing() < 150 ? 0 : (tabCell.getPlayerPing() < 300 ? 1 : (tabCell.getPlayerPing() < 600 ? 2 : (pingStatusIcon = tabCell.getPlayerPing() < 1000 ? 3 : 4))));
        if (!NecroTempusConfig.drawNumberedPing) {
            this.minecraft.func_110434_K().func_110577_a(field_110324_m);
            this.field_73735_i += 100.0f;
            GL11.glPushMatrix();
            this.func_73729_b(minX + maxCellSize - 11, minY, 0, 176 + pingStatusIcon * 8, 10, 8);
            GL11.glPopMatrix();
            this.field_73735_i -= 100.0f;
            return;
        }
        int[] color = new int[]{-16711936, -256, -14336, -65536, -8355712, -1};
        String ping = tabCell.getPlayerPing() + "ms";
        int size = this.minecraft.field_71466_p.func_78256_a(ping);
        this.minecraft.field_71466_p.func_78261_a(ping, minX + maxCellSize - size, minY, color[pingStatusIcon]);
    }

    private void drawScoreboardValues(ScoreObjective scoreObjective, int minY, int scoreboardEndX, TabCell tabCell) {
        int scorePoints = scoreObjective.func_96682_a().func_96529_a(tabCell.getLinkedUserName(), scoreObjective).func_96652_c();
        String score = scoreObjective.func_96680_c() == IScoreObjectiveCriteria.field_96638_f ? ChatFormatting.RED + "\u2764 " + scorePoints : ChatFormatting.YELLOW + String.valueOf(scorePoints);
        this.minecraft.field_71466_p.func_78261_a(score, scoreboardEndX - this.minecraft.field_71466_p.func_78256_a(score), minY, 0xFFFFFF);
    }

    public ResourceLocation getPlayerSkin(GameProfile gameProfile) {
        ResourceLocation resourcelocation = AbstractClientPlayer.field_110314_b;
        if (gameProfile != null) {
            MinecraftProfileTexture skin;
            if (NecroTempusConfig.enableSkinPortCompat && Loader.isModLoaded((String)"skinport") && skinProvider == null) {
                skinProvider = profile -> Hooks.GuiPlayerTabOverlay_bindTexture((GameProfile)profile, (ResourceLocation)AbstractClientPlayer.field_110314_b);
            }
            if (skinProvider != null) {
                return skinProvider.getSkin(gameProfile);
            }
            if (NecroTempusConfig.enableHeadsFallback && NecroTempusConfig.headsFallbackURL != null && !NecroTempusConfig.headsFallbackURL.isEmpty()) {
                String url = NecroTempusConfig.headsFallbackURL.replaceAll("%name%", gameProfile.getName());
                if (gameProfile.getId() != null) {
                    url = url.replaceAll("%uuid%", gameProfile.getId().toString()).replaceAll("%uuidTrim%", gameProfile.getId().toString().replaceAll("-", ""));
                }
                if (DOWNLOADING_SKINS.contains(url)) {
                    return AbstractClientPlayer.field_110314_b;
                }
                if (constructor == null) {
                    try {
                        constructor = MinecraftProfileTexture.class.getConstructor(String.class);
                    }
                    catch (Exception ignored) {
                        try {
                            constructor = MinecraftProfileTexture.class.getConstructor(String.class, Map.class);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                skin = null;
                if (constructor != null) {
                    skin = constructor.getParameterCount() == 1 ? constructor.newInstance(url) : constructor.newInstance(url, null);
                }
                if (skin != null) {
                    DOWNLOADING_SKINS.add(url);
                    String finalUrl = url;
                    return this.minecraft.func_152342_ad().func_152789_a(skin, MinecraftProfileTexture.Type.SKIN, (skinPart, skinLoc) -> DOWNLOADING_SKINS.remove(finalUrl));
                }
            }
            try {
                Map profile2 = this.minecraft.func_152342_ad().func_152788_a(gameProfile);
                skin = profile2 != null ? (MinecraftProfileTexture)profile2.getOrDefault(MinecraftProfileTexture.Type.SKIN, null) : null;
                resourcelocation = this.minecraft.func_152342_ad().func_152792_a(skin, MinecraftProfileTexture.Type.SKIN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resourcelocation;
    }

    public static String getFormattedPlayerName(String name, Minecraft minecraft) {
        Scoreboard scoreboard = minecraft.field_71441_e.func_96441_U();
        ScorePlayerTeam team = scoreboard.func_96509_i(name);
        if (team != null) {
            name = team.func_142053_d(name);
        }
        return name;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public boolean isDrawPlayerHeads() {
        return this.drawPlayerHeads;
    }

    public IChatComponent getFooter() {
        return this.footer;
    }

    public IChatComponent getHeader() {
        return this.header;
    }

    public long getLastTimeOpened() {
        return this.lastTimeOpened;
    }

    public boolean isBeingRendered() {
        return this.isBeingRendered;
    }

    public ScoreObjective getWorldScoreboardObjective() {
        return this.worldScoreboardObjective;
    }

    public void setDrawPlayerHeads(boolean drawPlayerHeads) {
        this.drawPlayerHeads = drawPlayerHeads;
    }

    public void setFooter(IChatComponent footer) {
        this.footer = footer;
    }

    public void setHeader(IChatComponent header) {
        this.header = header;
    }

    public void setLastTimeOpened(long lastTimeOpened) {
        this.lastTimeOpened = lastTimeOpened;
    }

    public void setBeingRendered(boolean isBeingRendered) {
        this.isBeingRendered = isBeingRendered;
    }

    public void setWorldScoreboardObjective(ScoreObjective worldScoreboardObjective) {
        this.worldScoreboardObjective = worldScoreboardObjective;
    }

    static {
        DOWNLOADING_SKINS = new HashSet();
        constructor = null;
    }
}

