/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.network;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class CommandAddModelParts
extends CommandBase {
    private static final String[] SUBCOMMANDS = new String[]{"add", "remove", "clear", "set", "item"};

    public String func_71517_b() {
        return "modelpartnpc";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/modelpartnpc <add|remove|clear|set|item> [...] (aplica na entidade que voc\u00ea est\u00e1 olhando)";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        NBTTagCompound tag;
        if (!(sender instanceof EntityPlayer)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Apenas jogadores podem usar este comando."));
            return;
        }
        if (args.length < 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Uso incorreto. " + this.func_71518_a(sender)));
            return;
        }
        String action = args[0].toLowerCase();
        ArrayList<Integer> parts = new ArrayList<Integer>();
        for (int i = 1; i < args.length; ++i) {
            try {
                parts.add(Integer.parseInt(args[i]));
                continue;
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Valor inv\u00e1lido: " + args[i]));
                return;
            }
        }
        EntityPlayer player = (EntityPlayer)sender;
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        float yaw = player.field_70177_z;
        float pitch = player.field_70125_A;
        double dirX = -Math.sin(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
        double dirY = -Math.sin(Math.toRadians(pitch));
        double dirZ = Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch));
        Vec3 eyePos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 lookVec = Vec3.func_72443_a((double)dirX, (double)dirY, (double)dirZ);
        Vec3 reach = eyePos.func_72441_c(dirX * 5.0, dirY * 5.0, dirZ * 5.0);
        Entity target = null;
        double closestDist = Double.MAX_VALUE;
        for (Object o : player.field_70170_p.field_72996_f) {
            double dist;
            MovingObjectPosition mop;
            Entity e;
            if (!(o instanceof Entity) || (e = (Entity)o) == player || (mop = e.field_70121_D.func_72314_b(0.3, 0.3, 0.3).func_72327_a(eyePos, reach)) == null || !((dist = eyePos.func_72438_d(mop.field_72307_f)) < closestDist)) continue;
            closestDist = dist;
            target = e;
        }
        if (target == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Nenhuma entidade encontrada na mira."));
            return;
        }
        if (!(target instanceof EntityLivingBase)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("A entidade n\u00e3o suporta ModelParts."));
            return;
        }
        EntityLivingBase living = (EntityLivingBase)target;
        ItemStack boots = living.func_71124_b(1);
        if (boots == null) {
            boots = new ItemStack(Items.field_151008_G);
            boots.func_151001_c("Modelos");
        }
        if ((tag = boots.func_77978_p()) == null) {
            tag = new NBTTagCompound();
        }
        if (action.equals("item")) {
            if (parts.isEmpty()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Uso: /modelpartnpc item <id_do_item>"));
                return;
            }
            int itemId = (Integer)parts.get(0);
            tag.func_74768_a("SheathItemID", itemId);
            boots.func_77982_d(tag);
            living.func_70062_b(1, boots);
            sender.func_145747_a((IChatComponent)new ChatComponentText("SheathItemID definido como " + itemId + " na entidade mirando."));
            return;
        }
        NBTTagCompound modelTag = tag.func_74764_b("ModelParts") ? tag.func_74775_l("ModelParts") : new NBTTagCompound();
        ArrayList<Integer> currentParts = new ArrayList<Integer>();
        int count = modelTag.func_74764_b("count") ? modelTag.func_74762_e("count") : 0;
        for (int i = 0; i < count; ++i) {
            currentParts.add(modelTag.func_74762_e("part" + i));
        }
        switch (action) {
            case "add": {
                Iterator iterator = parts.iterator();
                while (iterator.hasNext()) {
                    int p = (Integer)iterator.next();
                    if (currentParts.contains(p)) continue;
                    currentParts.add(p);
                }
                break;
            }
            case "remove": {
                currentParts.removeAll(parts);
                break;
            }
            case "clear": {
                currentParts.clear();
                break;
            }
            case "set": {
                currentParts = parts;
                break;
            }
            default: {
                sender.func_145747_a((IChatComponent)new ChatComponentText("A\u00e7\u00e3o inv\u00e1lida: " + action));
                return;
            }
        }
        modelTag.func_74768_a("count", currentParts.size());
        for (int i = 0; i < currentParts.size(); ++i) {
            modelTag.func_74768_a("part" + i, ((Integer)currentParts.get(i)).intValue());
        }
        tag.func_74782_a("ModelParts", (NBTBase)modelTag);
        boots.func_77982_d(tag);
        living.func_70062_b(1, boots);
        sender.func_145747_a((IChatComponent)new ChatComponentText("ModelParts atualizados na entidade mirando: " + currentParts));
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            for (String sub : SUBCOMMANDS) {
                if (!sub.startsWith(args[0].toLowerCase())) continue;
                list.add(sub);
            }
        }
        return list;
    }
}

