/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.command;

import com.DarknessCrow.main.mainRegistry;
import com.DarknessCrow.network.ModelPartsMessage;
import com.DarknessCrow.network.ServerModelPartsStorage;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandModelParts
extends CommandBase {
    public String func_71517_b() {
        return "modelparts";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/modelparts <add|remove|set|clear> <player> [partIds...]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Uso: " + this.func_71518_a(sender)));
            return;
        }
        String action = args[0].toLowerCase();
        String playerName = args[1];
        EntityPlayerMP player = CommandModelParts.func_82359_c((ICommandSender)sender, (String)playerName);
        if (player == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Jogador n\u00e3o encontrado!"));
            return;
        }
        int[] currentParts = ServerModelPartsStorage.getModelParts(player);
        switch (action) {
            case "add": {
                if (args.length < 3) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Uso: /modelparts add <player> <id>"));
                    return;
                }
                int[] partsToAdd = this.parseIds(args, 2);
                int[] newPartsAdd = new int[currentParts.length + partsToAdd.length];
                System.arraycopy(currentParts, 0, newPartsAdd, 0, currentParts.length);
                System.arraycopy(partsToAdd, 0, newPartsAdd, currentParts.length, partsToAdd.length);
                ServerModelPartsStorage.setModelParts(player, newPartsAdd);
                this.sendUpdate(player, newPartsAdd);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Partes adicionadas para " + playerName));
                break;
            }
            case "remove": {
                if (args.length < 3) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Uso: /modelparts remove <player> <id>"));
                    return;
                }
                int[] partsToRemove = this.parseIds(args, 2);
                ArrayList<Integer> updatedRemove = new ArrayList<Integer>();
                for (int part : currentParts) {
                    boolean keep = true;
                    for (int removeId : partsToRemove) {
                        if (part != removeId) continue;
                        keep = false;
                        break;
                    }
                    if (!keep) continue;
                    updatedRemove.add(part);
                }
                int[] newPartsRemove = updatedRemove.stream().mapToInt(i -> i).toArray();
                ServerModelPartsStorage.setModelParts(player, newPartsRemove);
                this.sendUpdate(player, newPartsRemove);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Partes removidas para " + playerName));
                break;
            }
            case "set": {
                if (args.length < 3) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Uso: /modelparts set <player> <id>"));
                    return;
                }
                int[] newSetParts = this.parseIds(args, 2);
                ServerModelPartsStorage.setModelParts(player, newSetParts);
                this.sendUpdate(player, newSetParts);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Partes definidas para " + playerName));
                break;
            }
            case "clear": {
                ServerModelPartsStorage.setModelParts(player, new int[0]);
                this.sendUpdate(player, new int[0]);
                sender.func_145747_a((IChatComponent)new ChatComponentText("Todas as partes removidas de " + playerName));
                break;
            }
            default: {
                sender.func_145747_a((IChatComponent)new ChatComponentText("A\u00e7\u00e3o inv\u00e1lida! Use add, remove, set ou clear."));
            }
        }
    }

    private void sendUpdate(EntityPlayerMP player, int[] parts) {
        ModelPartsMessage msg = new ModelPartsMessage(player.func_145782_y(), parts);
        mainRegistry.network.sendToAllAround((IMessage)msg, new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
    }

    private int[] parseIds(String[] args, int startIndex) {
        int[] ids = new int[args.length - startIndex];
        for (int i = startIndex; i < args.length; ++i) {
            try {
                ids[i - startIndex] = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ids[i - startIndex] = -1;
            }
        }
        return ids;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("add");
            completions.add("remove");
            completions.add("set");
            completions.add("clear");
        } else if (args.length == 2) {
            for (Object obj : sender.func_130014_f_().field_73010_i) {
                if (!(obj instanceof EntityPlayerMP)) continue;
                completions.add(((EntityPlayerMP)obj).func_70005_c_());
            }
        }
        return completions;
    }
}

