/*
 * Decompiled with CFR 0.152.
 */
package com.rnoverlays.server;

import com.rnoverlays.net.DBNNetwork;
import com.rnoverlays.net.PacketSetOverlay;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class ServerOverlayStore {
    private static final String NBT_ROOT = "dbnOverlays";

    private ServerOverlayStore() {
    }

    private static NBTTagCompound getPersist(EntityPlayerMP p) {
        NBTTagCompound persist;
        NBTTagCompound entityData = p.getEntityData();
        if (!entityData.func_74764_b("PlayerPersisted")) {
            persist = new NBTTagCompound();
            entityData.func_74782_a("PlayerPersisted", (NBTBase)persist);
        } else {
            persist = entityData.func_74775_l("PlayerPersisted");
        }
        return persist;
    }

    public static List<OverlayData> getOverlays(EntityPlayerMP p) {
        ArrayList<OverlayData> list = new ArrayList<OverlayData>();
        NBTTagCompound persist = ServerOverlayStore.getPersist(p);
        if (!persist.func_74764_b(NBT_ROOT)) {
            return list;
        }
        NBTTagList tagList = persist.func_150295_c(NBT_ROOT, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            OverlayData od = new OverlayData();
            od.url = tag.func_74779_i("url");
            od.xFrac = tag.func_74760_g("xFrac");
            od.yFrac = tag.func_74760_g("yFrac");
            od.wFrac = tag.func_74760_g("wFrac");
            od.alpha = tag.func_74760_g("alpha");
            od.layer = tag.func_74762_e("layer");
            list.add(od);
        }
        return list;
    }

    public static void setOverlays(EntityPlayerMP p, List<OverlayData> overlays) {
        NBTTagCompound persist = ServerOverlayStore.getPersist(p);
        NBTTagList tagList = new NBTTagList();
        for (OverlayData od : overlays) {
            if (od == null || od.url == null || od.url.isEmpty()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("url", od.url);
            tag.func_74776_a("xFrac", od.xFrac);
            tag.func_74776_a("yFrac", od.yFrac);
            tag.func_74776_a("wFrac", od.wFrac);
            tag.func_74776_a("alpha", od.alpha);
            tag.func_74768_a("layer", od.layer);
            tagList.func_74742_a((NBTBase)tag);
        }
        persist.func_74782_a(NBT_ROOT, (NBTBase)tagList);
    }

    public static void addOverlay(EntityPlayerMP p, OverlayData data) {
        List<OverlayData> list = ServerOverlayStore.getOverlays(p);
        list.add(data);
        ServerOverlayStore.setOverlays(p, list);
    }

    public static void clearOverlays(EntityPlayerMP p) {
        ServerOverlayStore.setOverlays(p, new ArrayList<OverlayData>());
    }

    public static void resendToClient(EntityPlayerMP p) {
        DBNNetwork.CHANNEL.sendTo((IMessage)new PacketSetOverlay(false, "", 0.0f, 0.0f, 0.0f, 1.0f, 1), p);
        List<OverlayData> list = ServerOverlayStore.getOverlays(p);
        for (OverlayData od : list) {
            DBNNetwork.CHANNEL.sendTo((IMessage)new PacketSetOverlay(true, od.url, od.xFrac, od.yFrac, od.wFrac, od.alpha, od.layer), p);
        }
    }

    public static void onPlayerLogin(EntityPlayerMP p) {
        ServerOverlayStore.resendToClient(p);
    }

    public static class OverlayData {
        public String url;
        public float xFrac;
        public float yFrac;
        public float wFrac;
        public float alpha;
        public int layer;

        public OverlayData() {
        }

        public OverlayData(String url, float xFrac, float yFrac, float wFrac, float alpha, int layer) {
            this.url = url;
            this.xFrac = xFrac;
            this.yFrac = yFrac;
            this.wFrac = wFrac;
            this.alpha = alpha;
            this.layer = layer;
        }
    }
}

