/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data.action;

import java.util.function.Consumer;
import noppes.npcs.api.handler.data.IAction;
import noppes.npcs.api.handler.data.IActionChain;
import noppes.npcs.scripted.ScriptedActionManager;

public class ParallelActionChain
implements IActionChain {
    private final ScriptedActionManager scriptedActionManager;
    private int offset = 0;
    private int idx = 0;

    public ParallelActionChain(ScriptedActionManager scriptedActionManager) {
        this.scriptedActionManager = scriptedActionManager;
    }

    @Override
    public IActionChain after(int delay, String name, Consumer<IAction> task) {
        this.offset += delay;
        Consumer<IAction> wrapper = act -> {
            task.accept((IAction)act);
            act.markDone();
        };
        IAction a = this.scriptedActionManager.create(name, this.offset, wrapper);
        ++this.idx;
        a.setUpdateEveryXTick(1);
        this.scriptedActionManager.scheduleParallelAction(a);
        return this;
    }

    @Override
    public IActionChain after(int delay, Consumer<IAction> task) {
        return this.after(delay, "parallel#" + this.idx, task);
    }
}

