/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kamkeel.npcs.network.PacketClient;
import kamkeel.npcs.network.packets.request.clone.CloneAllTagsPacket;
import kamkeel.npcs.network.packets.request.clone.CloneListPacket;
import kamkeel.npcs.network.packets.request.clone.CloneRemovePacket;
import kamkeel.npcs.network.packets.request.clone.CloneTagListPacket;
import kamkeel.npcs.network.packets.request.clone.MobSpawnerPacket;
import kamkeel.npcs.network.packets.request.clone.SpawnMobPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import noppes.npcs.client.controllers.ClientCloneController;
import noppes.npcs.client.controllers.ClientTagMapController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiCustomScrollCloner;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.controllers.data.Tag;
import noppes.npcs.controllers.data.TagMap;

public class GuiNpcMobSpawner
extends GuiNPCInterface
implements IGuiData {
    public static HashMap<UUID, Tag> tags = new HashMap();
    public static HashMap<String, UUID> tagNames = new HashMap();
    public static HashSet<String> tagFilters = new HashSet();
    public static byte displayTags = 0;
    public static byte filterCondition = 0;
    public static byte ascending = 0;
    public static byte sortType = 0;
    public TagMap tagMap;
    private final GuiCustomScrollCloner scroll = new GuiCustomScrollCloner(this, 0);
    private final GuiCustomScroll filterScroll = new GuiCustomScroll(this, 1);
    private int posX;
    private int posY;
    private int posZ;
    private List<String> list;
    private List<String> rawList;
    private List<String> tagList;
    private static int showingClones = 0;
    private static String search = "";
    private static String tagSearch = "";
    private int activeTab = 1;

    public GuiNpcMobSpawner(int i, int j, int k) {
        this.xSize = 354;
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
        PacketClient.sendClient(new CloneAllTagsPacket());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        this.guiLeft += 30;
        this.scroll.clear();
        this.scroll.setSize(293, 188);
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 26;
        this.filterScroll.clear();
        this.filterScroll.setSize(140, 166);
        this.filterScroll.guiLeft = this.guiLeft + 4;
        this.filterScroll.guiTop = this.guiTop + 19;
        this.filterScroll.multipleSelection = true;
        this.filterScroll.setSelectedList(tagFilters);
        GuiMenuTopButton button = new GuiMenuTopButton(3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        this.addTopButton(button);
        button.active = showingClones == 0;
        button = new GuiMenuTopButton(5, button, "gui.server");
        this.addTopButton(button);
        button.active = showingClones == 2;
        button = new GuiMenuTopButton(4, button, "spawner.entities");
        this.addTopButton(button);
        button.active = showingClones == 1;
        button = new GuiMenuTopButton(16, this.guiLeft + (this.xSize - 67), this.guiTop - 17, "gui.filters");
        this.addTopButton(button);
        button.active = showingClones == 3;
        button = new GuiMenuTopButton(17, this.guiLeft + (this.xSize - 22), this.guiTop - 17, "X");
        this.addTopButton(button);
        if (showingClones < 3) {
            this.addScroll(this.scroll);
            this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 4, this.guiTop + 4, 293, 20, search));
            this.addButton(new GuiNpcButton(1, this.guiLeft + 298, this.guiTop + 6, 52, 20, "item.monsterPlacer.name"));
            this.addButton(new GuiNpcButton(2, this.guiLeft + 298, this.guiTop + 140, 52, 20, "spawner.mobspawner"));
            if (showingClones == 0 || showingClones == 2) {
                this.addSideButton(new GuiMenuSideButton(21, this.guiLeft - 70, this.guiTop + 2, 70, 22, "1"));
                this.addSideButton(new GuiMenuSideButton(22, this.guiLeft - 70, this.guiTop + 23, 70, 22, "2"));
                this.addSideButton(new GuiMenuSideButton(23, this.guiLeft - 70, this.guiTop + 44, 70, 22, "3"));
                this.addSideButton(new GuiMenuSideButton(24, this.guiLeft - 70, this.guiTop + 65, 70, 22, "4"));
                this.addSideButton(new GuiMenuSideButton(25, this.guiLeft - 70, this.guiTop + 86, 70, 22, "5"));
                this.addSideButton(new GuiMenuSideButton(26, this.guiLeft - 70, this.guiTop + 107, 35, 22, "6"));
                this.addSideButton(new GuiMenuSideButton(27, this.guiLeft - 35, this.guiTop + 107, 35, 22, "7"));
                this.addSideButton(new GuiMenuSideButton(28, this.guiLeft - 70, this.guiTop + 128, 35, 22, "8"));
                this.addSideButton(new GuiMenuSideButton(29, this.guiLeft - 35, this.guiTop + 128, 35, 22, "9"));
                this.addSideButton(new GuiMenuSideButton(30, this.guiLeft - 70, this.guiTop + 149, 35, 22, "10"));
                this.addSideButton(new GuiMenuSideButton(31, this.guiLeft - 35, this.guiTop + 149, 35, 22, "11"));
                this.addSideButton(new GuiMenuSideButton(32, this.guiLeft - 70, this.guiTop + 170, 35, 22, "12"));
                this.addSideButton(new GuiMenuSideButton(33, this.guiLeft - 35, this.guiTop + 170, 35, 22, "13"));
                this.addSideButton(new GuiMenuSideButton(34, this.guiLeft - 70, this.guiTop + 191, 35, 22, "14"));
                this.addSideButton(new GuiMenuSideButton(35, this.guiLeft - 35, this.guiTop + 191, 35, 22, "15"));
                this.addButton(new GuiNpcButton(6, this.guiLeft + 298, this.guiTop + 190, 52, 20, "gui.remove"));
                this.getSideButton((int)(20 + this.activeTab)).active = true;
                this.showClones();
            } else {
                this.showEntities();
            }
        } else {
            this.addLabel(new GuiNpcLabel(1, StatCollector.func_74838_a((String)"cloner.tagFilters"), this.guiLeft + 7, this.guiTop + 7));
            this.addScroll(this.filterScroll);
            this.addTextField(new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 4, this.guiTop + 190, 140, 20, tagSearch));
            this.addLabel(new GuiNpcLabel(2, StatCollector.func_74838_a((String)"cloner.tagVisibility"), this.guiLeft + 150, this.guiTop + 27));
            this.addButton(new GuiNpcButton(12, this.guiLeft + 215, this.guiTop + 20, new String[]{"display.show", "display.all", "display.hide"}, displayTags));
            this.addLabel(new GuiNpcLabel(3, StatCollector.func_74838_a((String)"filter.contains"), this.guiLeft + 150, this.guiTop + 50));
            this.addButton(new GuiNpcButton(13, this.guiLeft + 215, this.guiTop + 43, new String[]{"filter.any", "filter.all", "filter.notany", "filter.notall"}, filterCondition));
            this.addButton(new GuiNpcButton(11, this.guiLeft + 150, this.guiTop + 66, 130, 20, "gui.deselectAll"));
            this.addLabel(new GuiNpcLabel(4, StatCollector.func_74838_a((String)"cloner.order"), this.guiLeft + 150, this.guiTop + 112));
            this.addButton(new GuiNpcButton(14, this.guiLeft + 215, this.guiTop + 105, new String[]{"cloner.ascending", "cloner.descending"}, ascending));
            this.addLabel(new GuiNpcLabel(5, StatCollector.func_74838_a((String)"cloner.type"), this.guiLeft + 150, this.guiTop + 135));
            this.addButton(new GuiNpcButton(15, this.guiLeft + 215, this.guiTop + 128, new String[]{"cloner.name", "cloner.date"}, sortType));
            this.getButton((int)12).field_146120_f = 65;
            this.getButton((int)12).field_146121_g = 20;
            this.getButton((int)13).field_146120_f = 65;
            this.getButton((int)13).field_146121_g = 20;
            this.getButton((int)14).field_146120_f = 65;
            this.getButton((int)14).field_146121_g = 20;
            this.getButton((int)15).field_146120_f = 65;
            this.getButton((int)15).field_146121_g = 20;
            this.showFilters();
        }
    }

    public int getShowingClones() {
        return showingClones;
    }

    public void showFilters() {
        this.filterScroll.setList(this.getTagList());
    }

    private void showEntities() {
        Map data = EntityList.field_75625_b;
        ArrayList<String> list = new ArrayList<String>();
        for (Object name : data.keySet()) {
            Class c = (Class)data.get(name);
            try {
                if (!EntityLiving.class.isAssignableFrom(c) || c.getConstructor(World.class) == null || Modifier.isAbstract(c.getModifiers())) continue;
                list.add(name.toString());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.list = list;
        this.rawList = new ArrayList<String>(this.list);
        this.scroll.setList(this.getSearchList(), ascending == 0, sortType == 0);
    }

    private void showClones() {
        if (showingClones == 2) {
            PacketClient.sendClient(new CloneTagListPacket(this.activeTab));
            PacketClient.sendClient(new CloneListPacket(this.activeTab));
            return;
        }
        this.list = sortType == 0 ? ClientCloneController.Instance.getClones(this.activeTab) : ClientCloneController.Instance.getClonesDate(this.activeTab);
        this.tagMap = ClientTagMapController.Instance.getTagMap(this.activeTab);
        this.rawList = new ArrayList<String>(this.list);
        if (this.tagMap != null && (displayTags == 0 || displayTags == 1)) {
            for (int i = 0; i < this.list.size(); ++i) {
                StringBuilder npcName = new StringBuilder(this.list.get(i));
                if (this.tagMap.hasClone(this.list.get(i))) {
                    for (UUID tagUUID : this.tagMap.getUUIDsList(this.list.get(i))) {
                        Tag tag = tags.get(tagUUID);
                        if (tag == null || displayTags != 1 && tag.getIsHidden()) continue;
                        npcName.append(" [" + tag.name + "]");
                    }
                }
                this.rawList.set(i, npcName.toString());
            }
        }
        this.scroll.setList(this.getSearchList(), ascending == 0, sortType == 0);
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (this.getTextField(1) != null) {
            if (search.equals(this.getTextField(1).func_146179_b())) {
                return;
            }
            search = this.getTextField(1).func_146179_b().toLowerCase();
            this.scroll.setList(this.getSearchList(), ascending == 0, sortType == 0);
        }
        if (this.getTextField(2) != null) {
            if (tagSearch.equals(this.getTextField(2).func_146179_b())) {
                return;
            }
            tagSearch = this.getTextField(2).func_146179_b().toLowerCase();
            this.filterScroll.setList(this.getTagList());
        }
    }

    private List<String> getSearchList() {
        if (this.list == null) {
            this.list = new ArrayList<String>();
        }
        if (this.rawList == null) {
            this.rawList = new ArrayList<String>();
        }
        if (tagFilters.size() == 0 || showingClones == 1) {
            if (search.isEmpty()) {
                return new ArrayList<String>(this.list);
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.rawList.get(i).toLowerCase().contains(search)) continue;
                list.add(this.list.get(i));
            }
            return list;
        }
        if (search.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            for (String name : this.list) {
                if (!this.tagMap.hasClone(name) || !this.meetsCondition(name)) continue;
                list.add(name);
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.list.size(); ++i) {
            String npcName;
            if (!this.rawList.get(i).toLowerCase().contains(search) || !this.tagMap.hasClone(npcName = this.list.get(i)) || !this.meetsCondition(npcName)) continue;
            list.add(npcName);
        }
        return list;
    }

    private boolean meetsCondition(String name) {
        if (this.tagMap == null) {
            return true;
        }
        boolean conditionMet = true;
        boolean allRequirement = filterCondition == 1 || filterCondition == 3;
        for (String tagName : tagFilters) {
            UUID tagUUID = tagNames.get(tagName);
            if (tagUUID == null) continue;
            boolean hasTag = this.tagMap.hasTag(name, tagUUID);
            if (!allRequirement) {
                if (!hasTag && filterCondition == 0) {
                    conditionMet = false;
                    break;
                }
                if (!hasTag || filterCondition != 2) continue;
                conditionMet = false;
                break;
            }
            if (!hasTag && filterCondition == 1) {
                conditionMet = false;
                break;
            }
            if (!hasTag || filterCondition != 3) continue;
            conditionMet = false;
            break;
        }
        return conditionMet;
    }

    private List<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new ArrayList<String>();
        }
        if (tagSearch.isEmpty()) {
            return new ArrayList<String>(tagNames.keySet());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.tagList) {
            if (!name.toLowerCase().contains(tagSearch)) continue;
            list.add(name);
        }
        return list;
    }

    private NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        if (showingClones == 0) {
            return ClientCloneController.Instance.getCloneData((ICommandSender)this.player, sel, this.activeTab);
        }
        Entity entity = EntityList.func_75620_a((String)sel, (World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_70039_c(compound);
        return compound;
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        GuiNpcButton button;
        NBTTagCompound compound;
        String sel;
        int id = guibutton.field_146127_k;
        if (id == 0) {
            this.close();
        }
        if (id == 1) {
            if (showingClones == 2) {
                sel = this.scroll.getSelected();
                if (sel == null) {
                    return;
                }
                SpawnMobPacket.Server(this.posX, this.posY, this.posZ, sel, this.activeTab);
                this.close();
            } else {
                compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                SpawnMobPacket.Client(this.posX, this.posY, this.posZ, compound);
                this.close();
            }
        }
        if (id == 2) {
            if (showingClones == 2) {
                sel = this.scroll.getSelected();
                if (sel == null) {
                    return;
                }
                MobSpawnerPacket.Server(this.posX, this.posY, this.posZ, sel, this.activeTab);
                this.close();
            } else {
                compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                MobSpawnerPacket.Client(this.posX, this.posY, this.posZ, compound);
                this.close();
            }
        }
        if (id == 3) {
            showingClones = 0;
            this.func_73866_w_();
        }
        if (id == 4) {
            showingClones = 1;
            this.func_73866_w_();
        }
        if (id == 5) {
            showingClones = 2;
            this.func_73866_w_();
        }
        if (id == 16) {
            showingClones = 3;
            this.func_73866_w_();
        }
        if (id == 17) {
            this.close();
        }
        if (id == 6 && this.scroll.getSelected() != null) {
            if (showingClones == 2) {
                PacketClient.sendClient(new CloneRemovePacket(this.activeTab, this.scroll.getSelected()));
                return;
            }
            ClientCloneController.Instance.removeClone(this.scroll.getSelected(), this.activeTab);
            this.scroll.selected = -1;
            this.func_73866_w_();
        }
        if (id == 11) {
            tagFilters = new HashSet();
            this.filterScroll.setSelectedList(tagFilters);
            this.func_73866_w_();
        }
        if (id == 12) {
            button = (GuiNpcButton)guibutton;
            displayTags = (byte)button.getValue();
        }
        if (id == 13) {
            button = (GuiNpcButton)guibutton;
            filterCondition = (byte)button.getValue();
        }
        if (id == 14) {
            button = (GuiNpcButton)guibutton;
            ascending = (byte)button.getValue();
        }
        if (id == 15) {
            button = (GuiNpcButton)guibutton;
            sortType = (byte)button.getValue();
        }
        if (id > 20) {
            this.activeTab = id - 20;
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("CloneTags")) {
            this.tagMap = new TagMap(this.activeTab);
            NBTTagCompound cloneTags = compound.func_74775_l("CloneTags");
            this.tagMap.readNBT(cloneTags);
        } else if (compound.func_74764_b("AllTags")) {
            NBTTagList validTags = compound.func_150295_c("AllTags", 10);
            if (validTags != null) {
                HashMap<UUID, Tag> tagsUpdate = new HashMap<UUID, Tag>();
                HashMap<String, UUID> tagNamesUpdate = new HashMap<String, UUID>();
                for (int j = 0; j < validTags.func_74745_c(); ++j) {
                    NBTTagCompound tagStructure = validTags.func_150305_b(j);
                    Tag tag = new Tag();
                    tag.readNBT(tagStructure);
                    tagsUpdate.put(tag.uuid, tag);
                    tagNamesUpdate.put(tag.name, tag.uuid);
                }
                tags = tagsUpdate;
                tagNames = tagNamesUpdate;
                this.tagList = new ArrayList<String>(tagNames.keySet());
                this.filterScroll.setList(this.getTagList());
            }
        } else {
            int i;
            NBTTagList nbtlist;
            ArrayList<String> list = new ArrayList<String>();
            if (sortType == 1) {
                nbtlist = compound.func_150295_c("ListDate", 8);
                for (i = 0; i < nbtlist.func_74745_c(); ++i) {
                    list.add(nbtlist.func_150307_f(i));
                }
            } else {
                nbtlist = compound.func_150295_c("List", 8);
                for (i = 0; i < nbtlist.func_74745_c(); ++i) {
                    list.add(nbtlist.func_150307_f(i));
                }
            }
            this.list = list;
            this.rawList = new ArrayList<String>(this.list);
            if (this.tagMap != null && (displayTags == 0 || displayTags == 1)) {
                for (int i2 = 0; i2 < this.list.size(); ++i2) {
                    StringBuilder npcName = new StringBuilder((String)list.get(i2));
                    if (this.tagMap.hasClone((String)list.get(i2))) {
                        for (UUID tagUUID : this.tagMap.getUUIDsList((String)list.get(i2))) {
                            Tag tag = tags.get(tagUUID);
                            if (tag == null || displayTags != 1 && tag.getIsHidden()) continue;
                            npcName.append(" [" + tag.name + "]");
                        }
                    }
                    this.rawList.set(i2, npcName.toString());
                }
            }
            this.scroll.setList(this.getSearchList(), ascending == 0, sortType == 0);
        }
    }
}

