/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import org.jetbrains.annotations.Nullable;

public class TextureKey
implements ITextureKey {
    protected final float u;
    protected final float v;
    protected final float width;
    protected final float height;
    protected final float totalWidth;
    protected final float totalHeight;
    protected final ITextureProvider provider;

    public TextureKey(float u, float v, float width, float height, ITextureProvider provider) {
        this(u, v, width, height, provider.getWidth(), provider.getHeight(), provider);
    }

    public TextureKey(float u, float v, float width, float height, float totalWidth, float totalHeight) {
        this(u, v, width, height, totalWidth, totalHeight, null);
    }

    public TextureKey(float u, float v, float width, float height, float totalWidth, float totalHeight, ITextureProvider provider) {
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.totalWidth = totalWidth;
        this.totalHeight = totalHeight;
        this.provider = provider;
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    @Override
    public float getU() {
        return this.u;
    }

    @Override
    public float getV() {
        return this.v;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getTotalWidth() {
        return this.totalWidth;
    }

    @Override
    public float getTotalHeight() {
        return this.totalHeight;
    }

    @Override
    @Nullable
    public ITextureProvider getProvider() {
        return this.provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextureKey)) {
            return false;
        }
        TextureKey that = (TextureKey)o;
        return Float.compare(that.u, this.u) == 0 && Float.compare(that.v, this.v) == 0 && Float.compare(that.width, this.width) == 0 && Float.compare(that.height, this.height) == 0 && Float.compare(that.totalWidth, this.totalWidth) == 0 && Float.compare(that.totalHeight, this.totalHeight) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.u), Float.valueOf(this.v), Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(this.totalWidth), Float.valueOf(this.totalHeight));
    }
}

