/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import java.util.EnumMap;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.texture.TextureKey;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.Nullable;

public class TextureBox {
    private final Vector2f texturePos;
    private final ITextureProvider defaultTexture;
    private final float width;
    private final float height;
    private final float depth;
    private final boolean mirror;
    private EnumMap<Direction, Rectangle2f> variantRects;
    private EnumMap<Direction, ITextureProvider> variantTextures;

    public TextureBox(float width, float height, float depth, boolean mirror, @Nullable Vector2f baseUV, @Nullable ITextureProvider defaultTexture) {
        this.texturePos = baseUV;
        this.defaultTexture = defaultTexture;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.mirror = mirror;
    }

    public void put(Direction dir, ITextureProvider textureProvider) {
        if (this.variantTextures == null) {
            this.variantTextures = new EnumMap(Direction.class);
        }
        this.variantTextures.put(dir, textureProvider);
    }

    public void put(Direction dir, Rectangle2f rect) {
        if (this.variantRects == null) {
            this.variantRects = new EnumMap(Direction.class);
        }
        this.variantRects.put(dir, rect);
    }

    public TextureBox separated() {
        TextureBox box = new TextureBox(this.width, this.height, this.depth, this.mirror, null, this.defaultTexture);
        for (Direction dir : Direction.values()) {
            ITextureKey key = this.getTexture(dir);
            if (key == null) continue;
            box.put(dir, new Rectangle2f(key.getU(), key.getV(), key.getWidth(), key.getHeight()));
            if (key.getProvider() == this.defaultTexture) continue;
            box.put(dir, key.getProvider());
        }
        return box;
    }

    @Nullable
    public ITextureKey getTexture(Direction dir) {
        Direction dir1 = this.resolveDirection(dir);
        switch (dir1) {
            case UP: {
                return this.makeTexture(dir1, this.depth, 0.0f, this.width, this.depth);
            }
            case DOWN: {
                return this.makeTexture(dir1, this.depth + this.width, 0.0f, this.width, this.depth);
            }
            case NORTH: {
                return this.makeTexture(dir1, this.depth, this.depth, this.width, this.height);
            }
            case SOUTH: {
                return this.makeTexture(dir1, this.depth + this.width + this.depth, this.depth, this.width, this.height);
            }
            case WEST: {
                return this.makeTexture(dir1, this.depth + this.width, this.depth, this.depth, this.height);
            }
            case EAST: {
                return this.makeTexture(dir1, 0.0f, this.depth, this.depth, this.height);
            }
        }
        return null;
    }

    private Direction resolveDirection(Direction dir) {
        if (this.mirror && dir.func_176740_k() == Direction.Axis.X) {
            return dir.func_176734_d();
        }
        return dir;
    }

    @Nullable
    private ITextureKey makeTexture(Direction dir, float u, float v, float s, float t) {
        ITextureProvider texture = this.getTextureProvider(dir);
        if (texture == null) {
            return null;
        }
        Rectangle2f rect = this.getTextureRect(dir);
        if (rect != null) {
            return new TextureKey(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), texture);
        }
        Vector2f pos = this.texturePos;
        if (pos != null) {
            return new Entry(pos.getX() + u, pos.getY() + v, s, t, texture, pos);
        }
        return null;
    }

    @Nullable
    private Rectangle2f getTextureRect(Direction dir) {
        if (this.variantRects != null) {
            return this.variantRects.get(dir);
        }
        return null;
    }

    private ITextureProvider getTextureProvider(Direction dir) {
        if (this.variantTextures != null) {
            return this.variantTextures.getOrDefault(dir, this.defaultTexture);
        }
        return this.defaultTexture;
    }

    public static class Entry
    extends TextureKey {
        protected final Vector2f parent;

        public Entry(float u, float v, float width, float height, ITextureProvider provider, Vector2f parent) {
            super(u, v, width, height, provider);
            this.parent = parent;
        }

        public Vector2f getParent() {
            return this.parent;
        }
    }
}

