/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class Vector3i
implements Comparable<Vector3i>,
IVector3i,
IPosition {
    public static final Vector3i ZERO = new Vector3i(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(double x, double y, double z) {
        this(MathUtils.floor(x), MathUtils.floor(y), MathUtils.floor(z));
    }

    public Vector3i(IPosition pos) {
        this(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
    }

    public Vector3i(IVector3i pos) {
        this(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3i)) {
            return false;
        }
        Vector3i v = (Vector3i)other;
        if (this.getX() != v.getX()) {
            return false;
        }
        if (this.getY() != v.getY()) {
            return false;
        }
        return this.getZ() == v.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vector3i v) {
        int dy = this.getY() - v.getY();
        if (dy != 0) {
            return dy;
        }
        int dz = this.getZ() - v.getZ();
        if (dz != 0) {
            return dz;
        }
        return this.getX() - v.getX();
    }

    public BlockPos asBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public double func_82615_a() {
        return this.x;
    }

    public double func_82617_b() {
        return this.y;
    }

    public double func_82616_c() {
        return this.z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int get(Direction.Axis axis) {
        return axis.func_196052_a(this.x, this.y, this.z);
    }

    public Vector3i above() {
        return this.above(1);
    }

    public Vector3i above(int step) {
        return this.relative(Direction.UP, step);
    }

    public Vector3i below() {
        return this.below(1);
    }

    public Vector3i below(int step) {
        return this.relative(Direction.DOWN, step);
    }

    public Vector3i relative(Direction dir, int i) {
        if (i == 0) {
            return this;
        }
        return new Vector3i(this.getX() + dir.func_82601_c() * i, this.getY() + dir.func_96559_d() * i, this.getZ() + dir.func_82599_e() * i);
    }

    public Vector3i cross(Vector3i pos) {
        return new Vector3i(this.getY() * pos.getZ() - this.getZ() * pos.getY(), this.getZ() * pos.getX() - this.getX() * pos.getZ(), this.getX() * pos.getY() - this.getY() * pos.getX());
    }

    public boolean closerThan(Vector3i pos, double d) {
        return this.distSqr(pos.getX(), pos.getY(), pos.getZ(), false) < d * d;
    }

    public boolean closerThan(IPosition v, double f) {
        return this.distSqr(v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), true) < f * f;
    }

    public double distSqr(Vector3i v) {
        return this.distSqr(v.getX(), v.getY(), v.getZ(), true);
    }

    public double distSqr(IPosition v, boolean fl) {
        return this.distSqr(v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), fl);
    }

    public double distSqr(double tx, double ty, double tz, boolean p_218140_7_) {
        double d0 = p_218140_7_ ? 0.5 : 0.0;
        double d1 = (double)this.getX() + d0 - tx;
        double d2 = (double)this.getY() + d0 - ty;
        double d3 = (double)this.getZ() + d0 - tz;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public int distManhattan(Vector3i pos) {
        float f = Math.abs(pos.getX() - this.getX());
        float f1 = Math.abs(pos.getY() - this.getY());
        float f2 = Math.abs(pos.getZ() - this.getZ());
        return (int)(f + f1 + f2);
    }

    public String toString() {
        return String.format("(%d %d %d)", this.x, this.y, this.z);
    }
}

