/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.dispenser.IPosition;

public class Vector3f
implements IVector3f,
IPosition {
    public static final int BYTES = 12;
    public static Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static Vector3f XN = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static Vector3f XP = new Vector3f(1.0f, 0.0f, 0.0f);
    public static Vector3f YN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static Vector3f ZN = new Vector3f(0.0f, 0.0f, -1.0f);
    public static Vector3f ZP = new Vector3f(0.0f, 0.0f, 1.0f);
    private float x;
    private float y;
    private float z;

    public Vector3f() {
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(IVector3f pos) {
        this(pos.getX(), pos.getY(), pos.getZ());
    }

    public Vector3f(IPosition pos) {
        this((float)pos.func_82615_a(), (float)pos.func_82617_b(), (float)pos.func_82616_c());
    }

    public Vector3f(float[] values) {
        this.set(values);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3f)) {
            return false;
        }
        Vector3f pos = (Vector3f)other;
        if (Float.compare(pos.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(pos.y, this.y) != 0) {
            return false;
        }
        return Float.compare(pos.z, this.z) == 0;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        return 31 * i + Float.floatToIntBits(this.z);
    }

    public double func_82615_a() {
        return this.x;
    }

    public double func_82617_b() {
        return this.y;
    }

    public double func_82616_c() {
        return this.z;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vector3f pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public void set(float[] values) {
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }

    public void add(float tx, float ty, float tz) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
    }

    public void add(Vector3f pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
    }

    public void subtract(float tx, float ty, float tz) {
        this.x -= tx;
        this.y -= ty;
        this.z -= tz;
    }

    public void subtract(Vector3f pos) {
        this.x -= pos.x;
        this.y -= pos.y;
        this.z -= pos.z;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public void scale(float sx, float sy, float sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public void scale(Vector3f pos) {
        this.x *= pos.x;
        this.y *= pos.y;
        this.z *= pos.z;
    }

    public void transform(IMatrix3f mat) {
        float[] floats = new float[]{this.x, this.y, this.z};
        mat.multiply(floats);
        this.set(floats[0], floats[1], floats[2]);
    }

    public void transform(IMatrix4f mat) {
        float[] floats = new float[]{this.x, this.y, this.z, 1.0f};
        mat.multiply(floats);
        this.set(floats[0], floats[1], floats[2]);
    }

    public void transform(OpenQuaternionf value) {
        OpenQuaternionf quaternion = new OpenQuaternionf(value);
        quaternion.mul(new OpenQuaternionf(this.x, this.y, this.z, 0.0f));
        OpenQuaternionf quaternion1 = new OpenQuaternionf(value);
        quaternion1.conj();
        quaternion.mul(quaternion1);
        this.set(quaternion.x(), quaternion.y(), quaternion.z());
    }

    public void normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)f < 1.0E-5) {
            return;
        }
        float f1 = MathUtils.fastInvSqrt(f);
        this.x *= f1;
        this.y *= f1;
        this.z *= f1;
    }

    public void cross(Vector3f pos) {
        float ax = this.x;
        float ay = this.y;
        float az = this.z;
        float bx = pos.getX();
        float by = pos.getY();
        float bz = pos.getZ();
        this.x = ay * bz - az * by;
        this.y = az * bx - ax * bz;
        this.z = ax * by - ay * bx;
    }

    public void clamp(float minValue, float maxValue) {
        this.x = MathUtils.clamp(this.x, minValue, maxValue);
        this.y = MathUtils.clamp(this.y, minValue, maxValue);
        this.z = MathUtils.clamp(this.z, minValue, maxValue);
    }

    public void lerp(Vector3f pos, float f) {
        float f1 = 1.0f - f;
        this.x = this.x * f1 + pos.x * f;
        this.y = this.y * f1 + pos.y * f;
        this.z = this.z * f1 + pos.z * f;
    }

    public float dot(Vector3f pos) {
        return this.x * pos.x + this.y * pos.y + this.z * pos.z;
    }

    public float length() {
        return MathUtils.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float distanceTo(Vector3f pos) {
        return MathUtils.sqrt(this.distanceToSquared(pos));
    }

    public float distanceToSquared(Vector3f pos) {
        return this.distanceToSquared(pos.x, pos.y, pos.z);
    }

    public float distanceToSquared(float tx, float ty, float tz) {
        float dx = this.x - tx;
        float dy = this.y - ty;
        float dz = this.z - tz;
        return dx * dx + dy * dy + dz * dz;
    }

    public OpenQuaternionf rotation(float f) {
        return new OpenQuaternionf(this, f, false);
    }

    public OpenQuaternionf rotationDegrees(float f) {
        return new OpenQuaternionf(this, f, true);
    }

    public Vector3f adding(float tx, float ty, float tz) {
        Vector3f ret = this.copy();
        ret.add(tx, ty, tz);
        return ret;
    }

    public Vector3f adding(Vector3f pos) {
        Vector3f ret = this.copy();
        ret.add(pos);
        return ret;
    }

    public Vector3f subtracting(float tx, float ty, float tz) {
        Vector3f ret = this.copy();
        ret.subtract(tx, ty, tz);
        return ret;
    }

    public Vector3f subtracting(Vector3f pos) {
        Vector3f ret = this.copy();
        ret.subtract(pos);
        return ret;
    }

    public Vector3f scaling(float scale) {
        Vector3f ret = this.copy();
        ret.scale(scale);
        return ret;
    }

    public Vector3f scaling(float sx, float sy, float sz) {
        Vector3f ret = this.copy();
        ret.scale(sx, sy, sz);
        return ret;
    }

    public Vector3f scaling(Vector3f pos) {
        Vector3f ret = this.copy();
        ret.scale(pos);
        return ret;
    }

    public Vector3f transforming(IMatrix3f mat) {
        Vector3f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public Vector3f transforming(IMatrix4f mat) {
        Vector3f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public Vector3f transforming(OpenQuaternionf value) {
        Vector3f ret = this.copy();
        ret.transform(value);
        return ret;
    }

    public Vector3f normalizing() {
        Vector3f ret = this.copy();
        ret.normalize();
        return ret;
    }

    public Vector3f crossing(Vector3f pos) {
        Vector3f ret = this.copy();
        ret.cross(pos);
        return ret;
    }

    public Vector3f clamping(float minValue, float maxValue) {
        Vector3f ret = this.copy();
        ret.clamp(minValue, maxValue);
        return ret;
    }

    public Vector3f copy() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("(%g %g %g)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

