/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenBoundingBox {
    public static final OpenBoundingBox ZERO = new OpenBoundingBox(Vector3f.ZERO, Vector3f.ZERO);
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;

    public OpenBoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public OpenBoundingBox(Vector3f min, Vector3f max) {
        this(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
    }

    public OpenBoundingBox(IRectangle3f rect) {
        this(rect.getMinX(), rect.getMinY(), rect.getMinZ(), rect.getMaxX(), rect.getMaxY(), rect.getMaxZ());
    }

    public void transform(IMatrix4f matrix) {
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        vertices.add(new Vector3f(this.minX, this.minY, this.minZ));
        vertices.add(new Vector3f(this.maxX, this.minY, this.minZ));
        vertices.add(new Vector3f(this.minX, this.maxY, this.minZ));
        vertices.add(new Vector3f(this.maxX, this.maxY, this.minZ));
        vertices.add(new Vector3f(this.minX, this.minY, this.maxZ));
        vertices.add(new Vector3f(this.maxX, this.minY, this.maxZ));
        vertices.add(new Vector3f(this.minX, this.maxY, this.maxZ));
        vertices.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.minZ = Float.MAX_VALUE;
        this.maxX = Float.MIN_VALUE;
        this.maxY = Float.MIN_VALUE;
        this.maxZ = Float.MIN_VALUE;
        for (Vector3f vertex : vertices) {
            vertex.transform(matrix);
            this.minX = Math.min(this.minX, vertex.getX());
            this.minY = Math.min(this.minY, vertex.getY());
            this.minZ = Math.min(this.minZ, vertex.getZ());
            this.maxX = Math.max(this.maxX, vertex.getX());
            this.maxY = Math.max(this.maxY, vertex.getY());
            this.maxZ = Math.max(this.maxZ, vertex.getZ());
        }
    }

    public boolean intersects(OpenBoundingBox box) {
        return this.intersects(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public boolean intersects(float d, float e, float f, float g, float h, float i) {
        return this.minX < g && this.maxX > d && this.minY < h && this.maxY > e && this.minZ < i && this.maxZ > f;
    }

    public boolean intersects(OpenRay ray) {
        return ray.intersects(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public OpenBoundingBox transforming(IMatrix4f matrix) {
        OpenBoundingBox ret = this.copy();
        ret.transform(matrix);
        return ret;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public OpenBoundingBox copy() {
        return new OpenBoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

