/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public class SkinCipher {
    private static final SkinCipher INSTANCE = new SkinCipher();
    private final byte[] alphabetOut = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890".getBytes();
    private final byte[] alphabetIn = new byte[256];

    private SkinCipher() {
        for (int i = 0; i < this.alphabetOut.length; ++i) {
            this.alphabetIn[this.alphabetOut[i] & 0xFF] = (byte)i;
        }
    }

    public static SkinCipher getInstance() {
        return INSTANCE;
    }

    public String encrypt(String ... values) {
        String value = this.join(values);
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < valueBytes.length; ++i) {
            valueBytes[i] = (byte)(valueBytes[i] ^ 0x77);
        }
        byte[] encodedBytes = this.convertTo(valueBytes, this.alphabetIn.length, this.alphabetOut.length);
        for (int i = 0; i < encodedBytes.length; ++i) {
            encodedBytes[i] = this.alphabetOut[encodedBytes[i]];
        }
        return new String(encodedBytes, StandardCharsets.UTF_8);
    }

    public String[] decrypt(String value) {
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < valueBytes.length; ++i) {
            valueBytes[i] = this.alphabetIn[valueBytes[i]];
        }
        byte[] decodedBytes = this.convertTo(valueBytes, this.alphabetOut.length, this.alphabetIn.length);
        for (int i = 0; i < decodedBytes.length; ++i) {
            decodedBytes[i] = (byte)(decodedBytes[i] ^ 0x77);
        }
        return new String(decodedBytes, StandardCharsets.UTF_8).split("\n");
    }

    private byte[] convertTo(byte[] message, int sourceBase, int targetBase) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte val : source) {
                int accumulator = (val & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        return this.reverse(out.toByteArray());
    }

    private byte[] reverse(byte[] bytes) {
        int n = bytes.length;
        for (int i = 0; i < n / 2; ++i) {
            byte t = bytes[i];
            bytes[i] = bytes[n - i - 1];
            bytes[n - i - 1] = t;
        }
        return bytes;
    }

    private String join(String[] values) {
        String separator = "";
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(separator);
            builder.append(value);
            separator = "\n";
        }
        return builder.toString();
    }
}

