/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.utils.PoseStackWrapper;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PoseUtils {
    public static PoseStackWrapper wrap(MatrixStack poseStack) {
        return new PoseStackWrapper(poseStack);
    }

    public static MatrixStack unwrap(IPoseStack poseStack) {
        if (poseStack instanceof PoseStackWrapper) {
            return ((PoseStackWrapper)poseStack).pose();
        }
        MatrixStack poseStack1 = new MatrixStack();
        ABI.mulPoseMatrix(poseStack1, poseStack.lastPose());
        ABI.mulNormalMatrix(poseStack1, poseStack.lastNormal());
        return poseStack1;
    }

    public static void apply(MatrixStack poseStack, ITransformf transform) {
        IVector3f offset;
        IVector3f scale;
        IVector3f rotation;
        if (transform.isIdentity()) {
            return;
        }
        IVector3f translate = transform.getTranslate();
        if (translate != Vector3f.ZERO) {
            poseStack.func_227861_a_((double)translate.getX(), (double)translate.getY(), (double)translate.getZ());
        }
        if ((rotation = transform.getRotation()) != Vector3f.ZERO) {
            IVector3f pivot = transform.getPivot();
            if (pivot != Vector3f.ZERO) {
                poseStack.func_227861_a_((double)pivot.getX(), (double)pivot.getY(), (double)pivot.getZ());
            }
            ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(rotation.getZ()));
            ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(rotation.getY()));
            ABI.mulPose(poseStack, Vector3f.XP.rotationDegrees(rotation.getX()));
            if (pivot != Vector3f.ZERO) {
                poseStack.func_227861_a_((double)(-pivot.getX()), (double)(-pivot.getY()), (double)(-pivot.getZ()));
            }
        }
        if ((scale = transform.getScale()) != Vector3f.ONE) {
            ABI.mulPoseMatrix(poseStack, OpenMatrix4f.createScaleMatrix(scale.getX(), scale.getY(), scale.getZ()));
            ABI.mulNormalMatrix(poseStack, OpenMatrix3f.createScaleMatrix(scale.getX(), scale.getY(), scale.getZ()));
        }
        if ((offset = transform.getOffset()) != Vector3f.ZERO) {
            poseStack.func_227861_a_((double)offset.getX(), (double)offset.getY(), (double)offset.getZ());
        }
    }
}

