/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class GJK {
    static final Logger log = Logger.getLogger("GJK");
    private static Vector3f Direction;
    private static final int MaxIterations = 20;

    public static boolean BodiesIntersect(ArrayList<Vector3f> shape1, ArrayList<Vector3f> shape2) {
        Vector3f initialPoint = shape1.get(0).subtracting(shape2.get(0));
        Vector3f S = GJK.MaxPointInMinkDiffAlongDir(shape1, shape2, initialPoint);
        Direction = Vector3f.ZERO.subtracting(S);
        ArrayList<Vector3f> simplex = new ArrayList<Vector3f>();
        simplex.add(S);
        for (int i = 0; i < 20; ++i) {
            Vector3f A = GJK.MaxPointInMinkDiffAlongDir(shape1, shape2, Direction);
            if (A.dot(Direction) < 0.0f) {
                return false;
            }
            simplex.add(A);
            log.info(String.format("GJK: %s", Direction.toString()));
            if (GJK.UpdateSimplexAndDirection(simplex)) {
                return true;
            }
            log.info(String.format("GJK: %s", Direction.toString()));
            log.info("");
        }
        return false;
    }

    private static boolean UpdateSimplexAndDirection(ArrayList<Vector3f> simplex) {
        switch (simplex.size()) {
            case 2: {
                Vector3f A = simplex.get(1);
                Vector3f B = simplex.get(0);
                Vector3f AB = B.subtracting(A);
                Vector3f AO = Vector3f.ZERO.subtracting(A);
                log.info(String.format("simplex2: %s", Direction.toString()));
                Direction = AB.dot(AO) > 0.0f ? AB.crossing(AO).crossing(AB) : AO;
                log.info(String.format("simplex2: %s", Direction.toString()));
                break;
            }
            case 3: {
                Vector3f A = simplex.get(2);
                Vector3f B = simplex.get(1);
                Vector3f C = simplex.get(0);
                Vector3f AO = Vector3f.ZERO.subtracting(A);
                Vector3f AB = B.subtracting(A);
                Vector3f AC = C.subtracting(A);
                Vector3f ABC = AB.crossing(AC);
                log.info(String.format("simplex3: %s", Direction.toString()));
                if (ABC.crossing(AC).dot(AO) > 0.0f) {
                    if (AC.dot(AO) > 0.0f) {
                        simplex.clear();
                        simplex.add(C);
                        simplex.add(A);
                        Direction = AC.crossing(AO).crossing(AC);
                    } else if (AB.dot(AO) > 0.0f) {
                        simplex.clear();
                        simplex.add(B);
                        simplex.add(A);
                        Direction = AB.crossing(AO).crossing(AB);
                    } else {
                        simplex.clear();
                        simplex.add(A);
                        Direction = AO;
                    }
                } else if (AB.crossing(ABC).dot(AO) > 0.0f) {
                    if (AB.dot(AO) > 0.0f) {
                        simplex.clear();
                        simplex.add(B);
                        simplex.add(A);
                        Direction = AB.crossing(AO).crossing(AB);
                    } else {
                        simplex.clear();
                        simplex.add(A);
                        Direction = AO;
                    }
                } else if (ABC.dot(AO) > 0.0f) {
                    Direction = ABC;
                } else {
                    simplex.clear();
                    simplex.add(B);
                    simplex.add(C);
                    simplex.add(A);
                    Direction = Vector3f.ZERO.subtracting(ABC);
                }
                log.info(String.format("simplex3: %s", Direction.toString()));
                break;
            }
            default: {
                Vector3f A = simplex.get(3);
                Vector3f B = simplex.get(2);
                Vector3f C = simplex.get(1);
                Vector3f D = simplex.get(0);
                Vector3f AO = Vector3f.ZERO.subtracting(A);
                Vector3f AB = B.subtracting(A);
                Vector3f AC = C.subtracting(A);
                Vector3f AD = D.subtracting(A);
                Vector3f ABC = AB.crossing(AC);
                Vector3f ACD = AC.crossing(AD);
                Vector3f ADB = AD.crossing(AB);
                int BsideOnACD = (int)Math.signum(ACD.dot(AB));
                int CsideOnADB = (int)Math.signum(ACD.dot(AC));
                int DsideOnABC = (int)Math.signum(ACD.dot(AD));
                boolean ABsameAsOrigin = Math.signum(ACD.dot(AO)) == (float)BsideOnACD;
                boolean ACsameAsOrigin = Math.signum(ACD.dot(AO)) == (float)CsideOnADB;
                boolean ADsameAsOrigin = Math.signum(ACD.dot(AO)) == (float)DsideOnABC;
                log.info(String.format("simplex4: %s", Direction.toString()));
                if (ABsameAsOrigin && ACsameAsOrigin && ADsameAsOrigin) {
                    return true;
                }
                if (!ABsameAsOrigin) {
                    simplex.remove(B);
                    Direction = ACD.scaling(-BsideOnACD);
                } else if (!ACsameAsOrigin) {
                    simplex.remove(C);
                    Direction = ADB.scaling(-CsideOnADB);
                } else {
                    simplex.remove(D);
                    Direction = ABC.scaling(-DsideOnABC);
                }
                log.info(String.format("simplex4: %s", Direction.toString()));
                return GJK.UpdateSimplexAndDirection(simplex);
            }
        }
        return false;
    }

    private static Vector3f MaxPointInMinkDiffAlongDir(ArrayList<Vector3f> shape1, ArrayList<Vector3f> shape2, Vector3f direction) {
        Vector3f max = GJK.MaxPointAlongDirection(shape1, direction).subtracting(GJK.MaxPointAlongDirection(shape2, Vector3f.ZERO.subtracting(direction)));
        return max;
    }

    private static Vector3f MaxPointAlongDirection(ArrayList<Vector3f> shape, Vector3f direction) {
        Vector3f max = shape.get(0).copy();
        for (Vector3f v : shape) {
            if (!(max.dot(direction) < v.dot(direction))) continue;
            max = v.copy();
        }
        return max;
    }

    private GJK() {
    }

    static {
        log.setLevel(Level.OFF);
    }
}

