/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;

public class DataStorageKey<T>
implements IAssociatedContainerKey<T> {
    private static final AtomicInteger GENERATOR = new AtomicInteger();
    private final int id = GENERATOR.getAndIncrement();
    private final String name;
    private final Class<T> type;
    private final Supplier<T> defaultValue;

    public DataStorageKey(String name, Class<T> type, Supplier<T> defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public static <T> DataStorageKey<T> of(String name, Class<T> type) {
        return new DataStorageKey<T>(name, type, null);
    }

    public static <T> DataStorageKey<T> of(String name, Class<T> type, Supplier<T> provider) {
        return new DataStorageKey<T>(name, type, provider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataStorageKey)) {
            return false;
        }
        DataStorageKey that = (DataStorageKey)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue.get();
        }
        return null;
    }
}

