/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.network;

import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class UpdateLibraryFilesPacket
extends CustomPacket {
    private final ArrayList<SkinLibraryFile> publicFiles;
    private final ArrayList<SkinLibraryFile> privateFiles;

    public UpdateLibraryFilesPacket(ArrayList<SkinLibraryFile> publicFiles, ArrayList<SkinLibraryFile> privateFiles) {
        this.publicFiles = publicFiles;
        this.privateFiles = privateFiles;
    }

    public UpdateLibraryFilesPacket(PacketBuffer buffer) {
        this.publicFiles = new ArrayList();
        this.privateFiles = new ArrayList();
        for (SkinLibraryFile file : this.readCompressedBuffer(new ByteBufInputStream((ByteBuf)buffer))) {
            if (file.getPath().startsWith("/private")) {
                this.privateFiles.add(file);
                continue;
            }
            this.publicFiles.add(file);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        int totalSize = this.publicFiles.size() + this.privateFiles.size();
        this.writeCompressedBuffer(new ByteBufOutputStream((ByteBuf)buffer), Iterables.concat(this.publicFiles, this.privateFiles), totalSize);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        SkinLibraryManager.Client client = SkinLibraryManager.getClient();
        client.getPublicSkinLibrary().reloadFiles(this.publicFiles);
        client.getPrivateSkinLibrary().reloadFiles(this.privateFiles);
    }

    private void writeCompressedBuffer(ByteBufOutputStream stream, Iterable<SkinLibraryFile> files, int totalSize) {
        try {
            stream.writeInt(totalSize);
            GZIPOutputStream go = new GZIPOutputStream((OutputStream)stream);
            ObjectOutputStream oo = new ObjectOutputStream(go);
            for (SkinLibraryFile file : files) {
                ArrayList<String> values = new ArrayList<String>();
                ISkinProperties properties = file.getSkinProperties();
                if (properties != null) {
                    values.add(file.getSkinType().toString());
                    values.add(properties.get(SkinProperty.ALL_CUSTOM_NAME));
                    values.add(properties.get(SkinProperty.ALL_AUTHOR_NAME));
                    values.add(properties.get(SkinProperty.ALL_FLAVOUR_TEXT));
                }
                oo.writeUTF(file.getPath());
                oo.writeByte(values.size());
                for (String value : values) {
                    oo.writeUTF(value);
                }
                if (values.size() == 0) continue;
                oo.writeInt(file.getSkinVersion());
                oo.writeInt(file.getLastModified());
            }
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Iterable<SkinLibraryFile> readCompressedBuffer(ByteBufInputStream stream) {
        ArrayList<SkinLibraryFile> files = new ArrayList<SkinLibraryFile>();
        try {
            int totalSize = stream.readInt();
            GZIPInputStream gi = new GZIPInputStream((InputStream)stream);
            ObjectInputStream oi = new ObjectInputStream(gi);
            for (int index = 0; index < totalSize; ++index) {
                String path = oi.readUTF();
                String basename = SkinFileUtils.getBaseName(path);
                if (oi.readByte() == 0) {
                    files.add(new SkinLibraryFile(DataDomain.DEDICATED_SERVER, basename, path));
                    continue;
                }
                ISkinType skinType = SkinTypes.byName(oi.readUTF());
                SkinProperties properties = new SkinProperties();
                properties.put(SkinProperty.ALL_CUSTOM_NAME, oi.readUTF());
                properties.put(SkinProperty.ALL_AUTHOR_NAME, oi.readUTF());
                properties.put(SkinProperty.ALL_FLAVOUR_TEXT, oi.readUTF());
                int fileVersion = oi.readInt();
                int lastModified = oi.readInt();
                SkinFileHeader header = SkinFileHeader.of(fileVersion, skinType, properties);
                header.setLastModified(lastModified);
                files.add(new SkinLibraryFile(DataDomain.DEDICATED_SERVER, basename, path, header));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }
}

