/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data.impl;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.utils.StreamUtils;

public class ServerRequest {
    private String path = "";
    private ServerPermission permission = null;
    private final ArrayList<String> query = new ArrayList();
    private final ArrayList<String> body = new ArrayList();

    public static ServerRequest fromJSON(IDataPackObject object) {
        ServerRequest request = new ServerRequest();
        object.get("path").ifPresent(it -> {
            request.path = it.stringValue();
        });
        object.get("query").allValues().forEach(it -> request.query.add(it.stringValue()));
        object.get("body").allValues().forEach(it -> request.body.add(it.stringValue()));
        if (request.path.isEmpty()) {
            return null;
        }
        return request;
    }

    public Callable<InputStream> build(String baseURL, Map<String, ?> parameters) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(baseURL);
        builder.append(this.path);
        String delimiter = "?";
        for (String it : this.query) {
            builder.append(delimiter);
            builder.append(this.getKey(it));
            builder.append("=");
            builder.append(this.getQueryValue(it, parameters));
            delimiter = "&";
        }
        if (this.body.isEmpty()) {
            URL url = new URL(builder.toString());
            return url::openStream;
        }
        MultipartForm multipartForm = new MultipartForm(builder.toString());
        for (String it : this.body) {
            multipartForm.add(this.getBodyValue(it, parameters));
        }
        return multipartForm::upload;
    }

    public boolean has(String key) {
        return this.query.contains(key) || this.body.contains(key);
    }

    public boolean isSSLRequired() {
        return this.permission != null && this.permission.isSSLRequired();
    }

    public String getPath() {
        return this.path;
    }

    public void setPermission(ServerPermission permission) {
        this.permission = permission;
    }

    public ServerPermission getPermission() {
        return this.permission;
    }

    private String getKey(String key) {
        if (key.contains("=")) {
            return this.getValue(key.split("="), 0);
        }
        return key;
    }

    private String getQueryValue(String key, Map<String, ?> parameters) throws Exception {
        if (key.contains("=")) {
            return this.getValue(key.split("="), 1);
        }
        Object value = parameters.get(key);
        if (value == null) {
            ModLog.debug("missing value of '{}' at '{}', with: {}", key, this.path, parameters);
            throw new RuntimeException("missing value of '" + key + "' at '" + this.path + "'");
        }
        return URLEncoder.encode(value.toString(), "UTF-8");
    }

    private MultipartForm.Value getBodyValue(String key, Map<String, ?> parameters) throws Exception {
        if (key.contains("=")) {
            String[] part = key.split("=");
            return new MultipartForm.Text(this.getValue(part, 0), this.getValue(part, 1));
        }
        Object value = parameters.get(key);
        if (value == null) {
            ModLog.debug("missing value of '{}' at '{}', with: {}", key, this.path, parameters);
            throw new RuntimeException("missing value of '" + key + "' at '" + this.path + "'");
        }
        if (value instanceof MultipartFormFile) {
            return ((MultipartFormFile)value).build(key);
        }
        return new MultipartForm.Text(key, value.toString());
    }

    private String getValue(String[] s1, int index) {
        if (index < s1.length) {
            return s1[index];
        }
        return "";
    }

    public static class MultipartForm {
        private static final String CRLF = "\r\n";
        private final String charset = "UTF-8";
        private final String uploadUrl;
        private final ArrayList<Value> values = new ArrayList();

        public MultipartForm(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        public void add(Value value) {
            this.values.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public InputStream upload() throws IOException {
            InputStream inputStream;
            String boundary = Long.toHexString(System.currentTimeMillis());
            URL uploadUrl = new URL(this.uploadUrl);
            URLConnection connection = uploadUrl.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream output = null;
            PrintWriter writer = null;
            try {
                output = connection.getOutputStream();
                writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), true);
                for (Value value : this.values) {
                    value.write(output, writer, boundary);
                }
                writer.append("--" + boundary + "--").append(CRLF).flush();
                inputStream = connection.getInputStream();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(writer);
                    StreamUtils.closeQuietly(output);
                    throw throwable;
                }
                StreamUtils.closeQuietly(writer);
                StreamUtils.closeQuietly(output);
                return null;
            }
            StreamUtils.closeQuietly(writer);
            StreamUtils.closeQuietly(output);
            return inputStream;
        }

        private static interface Value {
            public void write(OutputStream var1, PrintWriter var2, String var3) throws IOException;
        }

        private static class File
        implements Value {
            private final String name;
            private final String filename;
            private final ByteBuf fileBytes;

            public File(String name, String filename, ByteBuf fileBytes) {
                this.name = name;
                this.filename = filename;
                this.fileBytes = fileBytes;
            }

            @Override
            public void write(OutputStream output, PrintWriter writer, String boundary) throws IOException {
                writer.append("--" + boundary).append(MultipartForm.CRLF);
                writer.append("Content-Disposition: form-data; name=\"" + this.name + "\"; filename=\"" + this.filename + "\"").append(MultipartForm.CRLF);
                writer.append("Content-Type: application/octet-stream").append(MultipartForm.CRLF);
                writer.append("Content-Transfer-.Encoding: binary").append(MultipartForm.CRLF);
                writer.append(MultipartForm.CRLF).flush();
                output.write(this.fileBytes.array());
                output.flush();
                writer.append(MultipartForm.CRLF).flush();
            }
        }

        private static class Text
        implements Value {
            private final String name;
            private final String value;

            public Text(String name, String value) {
                this.name = name;
                this.value = value;
            }

            @Override
            public void write(OutputStream output, PrintWriter writer, String boundary) throws IOException {
                writer.append("--" + boundary).append(MultipartForm.CRLF);
                writer.append("Content-Disposition: form-data; name=\"" + this.name + "\"").append(MultipartForm.CRLF);
                writer.append("Content-Type: text/plain; charset=").append("UTF-8").append(MultipartForm.CRLF);
                writer.append(MultipartForm.CRLF);
                writer.append(this.value).append(MultipartForm.CRLF);
            }
        }
    }

    public static class MultipartFormFile {
        private final String name;
        private final Callable<ByteBuf> bytes;

        public MultipartFormFile(String name, Callable<ByteBuf> bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public MultipartForm.File build(String key) throws Exception {
            return new MultipartForm.File(key, this.name, this.bytes.call());
        }
    }
}

