/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.coregraphics.CGGradient;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractLibraryPanel
extends UIView {
    public final Predicate<GlobalSkinLibraryWindow.Page> predicate;
    protected GlobalSkinLibraryWindow.Router router;
    private final String baseKey;

    public AbstractLibraryPanel(String titleKey, Predicate<GlobalSkinLibraryWindow.Page> predicate) {
        super(new CGRect(0.0f, 0.0f, 320.0f, 240.0f));
        this.setContents(this.getDefaultColor());
        this.baseKey = titleKey;
        this.predicate = predicate;
    }

    public void tick() {
    }

    public void refresh() {
    }

    @Override
    public boolean pointInside(CGPoint point, UIEvent event) {
        if (super.pointInside(point, event)) {
            return true;
        }
        return this.subviews().stream().anyMatch(subview -> subview.pointInside(this.convertPointToView(point, (UIView)subview), event));
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString(this.baseKey + "." + key, objects);
    }

    protected NSString getURLText(String url) {
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        return new NSString((ITextComponent)TranslatableProvider.literal(ITextComponent.class, url).func_240703_c_(style));
    }

    protected CGGradient getDefaultColor() {
        UIColor startColor = UIColor.rgba(-1072689136);
        UIColor endColor = UIColor.rgba(-804253680);
        return new CGGradient(startColor, CGPoint.ZERO, endColor, CGPoint.ZERO);
    }

    public GlobalSkinLibraryWindow.Router getRouter() {
        return this.router;
    }

    public void setRouter(GlobalSkinLibraryWindow.Router router) {
        this.router = router;
    }
}

