/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import extensions.net.minecraft.core.Registry.ForgeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.registry.IItemGroupBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;

public class ItemGroupBuilderImpl<T extends IItemGroup>
implements IItemGroupBuilder<T> {
    private Supplier<Supplier<ItemStack>> icon = () -> () -> ItemStack.field_190927_a;

    @Override
    public IItemGroupBuilder<T> icon(Supplier<Supplier<ItemStack>> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public IRegistryKey<T> build(String name) {
        ItemGroup group = new ItemGroup(name);
        return AbstractForgeRegistryEntry.cast(ModConstants.key(name), () -> group);
    }

    public class ItemGroup
    implements IItemGroup {
        private final IRegistryKey<net.minecraft.item.ItemGroup> tab;
        private final ArrayList<Supplier<Item>> items = new ArrayList();

        public ItemGroup(String name) {
            this.tab = ForgeProvider.registerItemGroupFO(Registry.class, name, ItemGroupBuilderImpl.this.icon, this::fill);
        }

        public void fill(List<ItemStack> results) {
            for (Supplier<Item> itemProvider : this.items) {
                Item item = itemProvider.get();
                results.add(item.func_190903_i());
                IItemGroupProvider provider = ObjectUtils.safeCast(item, IItemGroupProvider.class);
                if (provider == null) continue;
                provider.fillItemGroup(results, this);
            }
        }

        @Override
        public void add(Supplier<Item> item) {
            this.items.add(item);
        }

        @Override
        public net.minecraft.item.ItemGroup get() {
            return (net.minecraft.item.ItemGroup)this.tab.get();
        }
    }
}

