/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge;

import java.util.UUID;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeNetworkManager;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.PacketSplitter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkManagerImpl
extends AbstractForgeNetworkManager
implements NetworkManager.Impl {
    private static NetworkDispatcher dispatcher;

    public static NetworkManager.Impl getInstance(String name, String version) {
        NetworkManagerImpl impl = new NetworkManagerImpl();
        impl.init(name, version);
        return impl;
    }

    public void init(String name, String version) {
        dispatcher = new NetworkDispatcher(ModConstants.key(name));
        AbstractForgeNetworkManager.register(NetworkManagerImpl.dispatcher.channelName, version, dispatcher);
    }

    @Override
    public void sendToTrackingChunk(CustomPacket message, Chunk chunk) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.trackingChunk(() -> chunk)).send(arg_0));
    }

    @Override
    public void sendToTracking(CustomPacket message, Entity entity) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.trackingEntityAndSelf(() -> entity)).send(arg_0));
    }

    @Override
    public void sendTo(CustomPacket message, ServerPlayerEntity player) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((ServerPlayNetHandler)player.field_71135_a).func_147359_a(arg_0));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(CustomPacket message) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_SERVER, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.server()).send(arg_0));
    }

    @Override
    public void sendToAll(CustomPacket message) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.allPlayers()).send(arg_0));
    }

    public static class NetworkDispatcher
    implements IServerPacketHandler,
    IClientPacketHandler {
        final UUID clientUUID = UUID.randomUUID();
        final ResourceLocation channelName;
        final PacketSplitter splitter;
        final int maxPartSize = 32000;

        NetworkDispatcher(ResourceLocation channelName) {
            this.channelName = channelName;
            this.splitter = new PacketSplitter();
        }

        @SubscribeEvent
        public void onServerEvent(NetworkEvent.ClientCustomPayloadEvent event) {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            NetworkDispatcher packetHandler = this;
            this.merge(player.func_110124_au(), event.getPayload(), packet -> context.enqueueWork(() -> packet.accept(packetHandler, player)));
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void onClientEvent(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            NetworkDispatcher packetHandler = this;
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            this.merge(this.clientUUID, event.getPayload(), packet -> context.enqueueWork(() -> packet.accept(packetHandler, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)));
            context.setPacketHandled(true);
        }

        public void merge(UUID uuid, PacketBuffer buffer, Consumer<CustomPacket> consumer) {
            this.splitter.merge(uuid, buffer, consumer);
        }

        public void split(CustomPacket message, AbstractForgeNetworkManager.Direction dir, Consumer<IPacket<?>> consumer) {
            int partSize = 32000;
            if (dir == AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT) {
                partSize = Integer.MAX_VALUE;
            }
            this.splitter.split(message, buf -> dir.buildPacket((Pair<PacketBuffer, Integer>)Pair.of((Object)buf, (Object)0), this.channelName).getThis(), partSize, packet -> dir.enqueueWork(() -> consumer.accept((IPacket<?>)packet)));
        }
    }
}

