/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge;

import java.io.File;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.forge.builder.ConfigBuilderImpl;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class EnvironmentManagerImpl {
    private static MinecraftServer CURRENT_SERVER;

    public static String getVersion() {
        ModFileInfo fileInfo = ModList.get().getModFileById("armourers_workshop");
        if (fileInfo != null && fileInfo.getMods().size() != 0) {
            ArtifactVersion version = ((IModInfo)fileInfo.getMods().get(0)).getVersion();
            return version.toString();
        }
        return "Unknown";
    }

    public static EnvironmentType getEnvironmentType() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return EnvironmentType.SERVER;
        }
        return EnvironmentType.CLIENT;
    }

    public static MinecraftServer getServer() {
        return CURRENT_SERVER;
    }

    public static File getRootDirectory() {
        return new File(FMLPaths.GAMEDIR.get().toFile(), "armourers_workshop");
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    public static IConfigSpec getClientConfigSpec() {
        return ConfigBuilderImpl.createClientSpec();
    }

    public static IConfigSpec getCommonConfigSpec() {
        return ConfigBuilderImpl.createCommonSpec();
    }

    public static void attach(MinecraftServer server) {
        CURRENT_SERVER = server;
    }

    public static void detach(MinecraftServer server) {
        CURRENT_SERVER = null;
    }

    public static boolean isInstalled(String modId) {
        return ModList.get().getModFileById(modId) != null;
    }
}

