/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.util.function.Function;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModels;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractSkinnableRenderers;
import moe.plushie.armourers_workshop.core.client.skinrender.ArrowSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.BipedSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.ChickenSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.CreeperSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.FirstPersonSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.GhastSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.IllagerSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.IronGolemSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.PlayerSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.client.skinrender.SlimeSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.TridentSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.VillagerSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.ZombieVillagerSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.MobLayerFixPlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.SlimeOuterFixPlugin;
import moe.plushie.armourers_workshop.core.client.skinrender.plugin.VillagerLayerFixPlugin;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererRegistries {
    public static void init() {
        SkinRendererManager manager = SkinRendererManager.getInstance();
        SkinRendererRegistries.adapt();
        ModEntityProfiles.addListener(manager::unbind, manager::bind);
        manager.registerPlugin(SlimeSkinRenderer.class, new SlimeOuterFixPlugin());
        manager.registerPlugin(VillagerSkinRenderer.class, new VillagerLayerFixPlugin());
        manager.registerPlugin(ZombieVillagerSkinRenderer.class, new VillagerLayerFixPlugin());
        manager.registerPlugin(BipedSkinRenderer.class, new MobLayerFixPlugin());
    }

    protected static void adapt() {
        SkinRendererRegistries.registerRenderer(ArrowSkinRenderer::new, null, AbstractSkinnableRenderers.ARROW);
        SkinRendererRegistries.registerRenderer(TridentSkinRenderer::new, null, AbstractSkinnableRenderers.THROWN_TRIDENT);
        SkinRendererRegistries.registerRenderer(IllagerSkinRenderer::new, AbstractSkinnableModels.ILLAGER, null);
        SkinRendererRegistries.registerRenderer(ZombieVillagerSkinRenderer::new, AbstractSkinnableModels.ZOMBIE_VILLAGER, null);
        SkinRendererRegistries.registerRenderer(VillagerSkinRenderer::new, AbstractSkinnableModels.VILLAGER, null);
        SkinRendererRegistries.registerRenderer(IronGolemSkinRenderer::new, AbstractSkinnableModels.IRON_GOLE, null);
        SkinRendererRegistries.registerRenderer(FirstPersonSkinRenderer::new, AbstractSkinnableModels.FIRST_PERSON_PLAYER, null);
        SkinRendererRegistries.registerRenderer(PlayerSkinRenderer::new, AbstractSkinnableModels.PLAYER, null);
        SkinRendererRegistries.registerRenderer(BipedSkinRenderer::new, AbstractSkinnableModels.HUMANOID, null);
        SkinRendererRegistries.registerRenderer(SlimeSkinRenderer::new, AbstractSkinnableModels.SLIME, null);
        SkinRendererRegistries.registerRenderer(GhastSkinRenderer::new, AbstractSkinnableModels.GHAST, null);
        SkinRendererRegistries.registerRenderer(ChickenSkinRenderer::new, AbstractSkinnableModels.CHICKEN, null);
        SkinRendererRegistries.registerRenderer(CreeperSkinRenderer::new, AbstractSkinnableModels.CREEPER, null);
        SkinRendererRegistries.registerOptionalRenderer(BipedSkinRenderer::new, AbstractSkinnableModels.ALLAY, null);
    }

    protected static void registerRenderer(Function<EntityProfile, SkinRenderer<?, ?>> factory, Class<?> modelClass, Class<?> rendererClass) {
        Builder builder = new Builder();
        builder.factory = factory;
        builder.modelClass = modelClass;
        builder.rendererClass = rendererClass;
        SkinRendererManager.getInstance().registerRenderer(builder);
    }

    protected static void registerOptionalRenderer(Function<EntityProfile, SkinRenderer<?, ?>> factory, Class<?> modelClass, Class<?> rendererClass) {
        if (modelClass != null || rendererClass != null) {
            SkinRendererRegistries.registerRenderer(factory, modelClass, rendererClass);
        }
    }

    protected static class Builder
    implements SkinRenderer.Factory<SkinRenderer<?, ?>> {
        Class<?> modelClass;
        Class<?> rendererClass;
        Function<EntityProfile, SkinRenderer<?, ?>> factory;

        protected Builder() {
        }

        @Override
        @Nullable
        public SkinRenderer<?, ?> create(EntityType<?> entityType, EntityRenderer<?> entityRenderer, Model entityModel, EntityProfile entityProfile) {
            if (this.modelClass != null && !this.modelClass.isInstance(entityModel)) {
                return null;
            }
            if (this.rendererClass != null && !this.rendererClass.isInstance(entityRenderer)) {
                return null;
            }
            SkinRenderer<?, ?> skinRenderer = this.factory.apply(entityProfile);
            skinRenderer.initWithRenderer(entityRenderer);
            return skinRenderer;
        }
    }
}

