/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.common.IArgumentType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class FileArgumentType
implements IArgumentType<String> {
    public static final SimpleCommandExceptionType ERROR_START = new SimpleCommandExceptionType((Message)TranslatableProvider.literal(ITextComponent.class, "File must start with '/'"));
    public static final SimpleCommandExceptionType ERROR_NOT_FOUND = new SimpleCommandExceptionType((Message)TranslatableProvider.literal(ITextComponent.class, "Not found any file"));
    private static final Collection<String> EXAMPLES = ObjectUtils.map("/", "/file.armour", "\"<scheme>:<identifier>\"");
    private final File rootFile;
    private final ArrayList<String> fileList;
    private final StringArgumentType stringType = StringArgumentType.string();
    private String filteredName;
    private ArrayList<String> filteredFileList;

    public FileArgumentType(File rootPath) {
        this.rootFile = rootPath;
        this.fileList = null;
        ModLog.debug("setup root path: " + rootPath, new Object[0]);
    }

    FileArgumentType(ArrayList<String> fileList) {
        this.rootFile = null;
        this.fileList = fileList;
    }

    public static String getString(CommandContext<CommandSource> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String inputPath = reader.getRemaining();
        if (inputPath.startsWith("\"")) {
            return this.stringType.parse(reader);
        }
        if (inputPath.startsWith("/")) {
            ArrayList<String> fileList = this.getFileList(inputPath);
            if (fileList.isEmpty()) {
                throw ERROR_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
            }
            reader.setCursor(reader.getCursor() + inputPath.length());
            return inputPath;
        }
        throw ERROR_START.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList<String> fileList;
        String inputPath = builder.getRemaining();
        if (inputPath.startsWith("/") && !(fileList = this.getFileList(inputPath)).isEmpty()) {
            return this.suggestFiles(fileList, inputPath, builder);
        }
        return ISuggestionProvider.func_197005_b(ObjectUtils.map("/", "\""), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private CompletableFuture<Suggestions> suggestFiles(ArrayList<String> fileList, String inputPath, SuggestionsBuilder builder) {
        String parent = this.getParentPath(inputPath);
        builder = builder.createOffset(builder.getStart() + parent.length());
        for (String file : fileList) {
            String name = SkinFileUtils.getRelativePath(file, parent);
            if (name.isEmpty()) continue;
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    private ArrayList<String> getFileList(String name) {
        if (Objects.equals(name, this.filteredName)) {
            return this.filteredFileList;
        }
        if (this.rootFile != null) {
            this.filteredName = name;
            this.filteredFileList = this.getFileList(this.rootFile, name);
        } else {
            this.filteredName = name;
            this.filteredFileList = this.getFileList(this.fileList, name);
        }
        return this.filteredFileList;
    }

    public ArrayList<String> getFileList(File parentFile, String name) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = parentFile.listFiles();
        if (files == null) {
            ModLog.error("load file error at {}", parentFile);
            return results;
        }
        for (File file : files) {
            String rv = SkinFileUtils.getRelativePath(file, this.rootFile, true);
            if (file.isDirectory()) {
                if (name.startsWith(rv)) {
                    results.addAll(this.getFileList(file, name));
                    continue;
                }
                if (!rv.startsWith(name)) continue;
                results.addAll(this.getFileList(file, name));
                continue;
            }
            if (!rv.toLowerCase().endsWith(".armour")) continue;
            if (rv.startsWith(name)) {
                results.add(rv);
                continue;
            }
            if (!name.startsWith(rv)) continue;
            results.add(rv);
        }
        return results;
    }

    public ArrayList<String> getFileList(ArrayList<String> fileList, String name) {
        ArrayList<String> results = new ArrayList<String>();
        for (String file : fileList) {
            if (!file.startsWith(name)) continue;
            results.add(file);
        }
        return results;
    }

    private String getParentPath(String file) {
        int index = file.lastIndexOf("/");
        if (index <= 0) {
            return "/";
        }
        return file.substring(0, index) + "/";
    }

    public static class Serializer
    implements IArgumentSerializer<FileArgumentType> {
        @Override
        public void serializeToNetwork(FileArgumentType argument, PacketBuffer buffer) {
            ArrayList lists = argument.getFileList("/");
            buffer.writeInt(lists.size());
            lists.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
        }

        @Override
        public FileArgumentType deserializeFromNetwork(PacketBuffer buffer) {
            int size = buffer.readInt();
            ArrayList<String> lists = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                lists.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
            return new FileArgumentType(lists);
        }

        @Override
        public void serializeToJson(FileArgumentType argument, JsonObject json) {
            JsonArray array = new JsonArray();
            ArrayList lists = argument.getFileList("/");
            lists.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.add("files", (JsonElement)array);
        }
    }
}

