/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.command.ColorArgumentType;
import moe.plushie.armourers_workshop.init.command.ColorSchemeArgumentType;
import moe.plushie.armourers_workshop.init.command.ComponentArgumentType;
import moe.plushie.armourers_workshop.init.command.FileArgumentType;
import moe.plushie.armourers_workshop.init.command.ListArgumentType;
import moe.plushie.armourers_workshop.init.command.ReflectArgumentBuilder;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.MenuManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.init.platform.RegistryManager;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class ModCommands {
    private static final HashMap<String, ISkinPaintType> DYE_TYPES = (HashMap)Util.func_199748_a(() -> {
        HashMap<String, SkinPaintType> map = new HashMap<String, SkinPaintType>();
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.getRegistryName().func_110623_a();
            map.put(name.replaceAll("_", ""), paintType);
        }
        return map;
    });
    private static final DynamicCommandExceptionType ERROR_MISSING_DYE_SLOT = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingSkin", ob));
    private static final DynamicCommandExceptionType ERROR_MISSING_SKIN = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingSkin", ob));
    private static final DynamicCommandExceptionType ERROR_MISSING_ITEM_STACK = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingItemSkinnable", ob));

    public static void init(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(ModCommands.commands());
    }

    public static LiteralArgumentBuilder<CommandSource> commands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"armourers").then(ReflectArgumentBuilder.literal("config", ModConfig.Client.class))).then(ReflectArgumentBuilder.literal("debug", ModDebugger.class))).requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"library").then(Commands.func_197057_a((String)"reload").executes(Executor::reloadLibrary)))).then(Commands.func_197057_a((String)"setSkin").then(ModCommands.entities().then(ModCommands.slots().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))).then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))))).then(Commands.func_197057_a((String)"giveSkin").then(ModCommands.players().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::giveSkin)).executes(Executor::giveSkin))))).then(Commands.func_197057_a((String)"clearSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().executes(Executor::clearSkin))).executes(Executor::clearSkin)))).then(Commands.func_197057_a((String)"exportSkin").then(ModCommands.skinFormats().then(ModCommands.outputFileName().then(ModCommands.scale().executes(Executor::exportSkin)).executes(Executor::exportSkin))))).then(Commands.func_197057_a((String)"setColor").then(ModCommands.entities().then(ModCommands.dyesSlotNames().then(ModCommands.dyeColor().executes(Executor::setColor)))))).then(Commands.func_197057_a((String)"rsyncWardrobe").then(ModCommands.players().executes(Executor::resyncWardrobe)))).then(Commands.func_197057_a((String)"openWardrobe").then(ModCommands.entities().executes(Executor::openWardrobe)))).then(Commands.func_197057_a((String)"itemSkinnable").then(ModCommands.addOrRemote().then(ModCommands.overrideTypes().executes(Executor::setItemSkinnable))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"notify").then(Commands.func_197057_a((String)"alert").then(ModCommands.alertNotifyArgs()))).then(Commands.func_197057_a((String)"toast").then(ModCommands.toastNotifyArgs())))).then(Commands.func_197057_a((String)"setUnlockedSlots").then(ModCommands.entities().then(ModCommands.resizableSlotNames().then(ModCommands.resizableSlotAmounts().executes(Executor::setUnlockedWardrobeSlots)))));
    }

    public static ArgumentBuilder<CommandSource, ?> alertNotifyArgs() {
        return ModCommands.players().then(ModCommands.textInput("message").then(ModCommands.textInput("title").then(ModCommands.textInput("confirm").executes(Executor::sendAlertNotify)).executes(Executor::sendAlertNotify)).executes(Executor::sendAlertNotify));
    }

    public static ArgumentBuilder<CommandSource, ?> toastNotifyArgs() {
        return ModCommands.players().then(ModCommands.textInput("message").then(ModCommands.textInput("title").then(ModCommands.nbtInput("icon").executes(Executor::sendToastNotify)).executes(Executor::sendToastNotify)).executes(Executor::sendToastNotify));
    }

    static ArgumentBuilder<CommandSource, ?> players() {
        return Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d());
    }

    static ArgumentBuilder<CommandSource, ?> entities() {
        return Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b());
    }

    static ArgumentBuilder<CommandSource, ?> slots() {
        return Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<CommandSource, ?> skinFormats() {
        return Commands.func_197056_a((String)"format", (ArgumentType)ListArgumentType.list(SkinExportManager.getExporters()));
    }

    static ArgumentBuilder<CommandSource, ?> skinDying() {
        return Commands.func_197056_a((String)"dying", (ArgumentType)new ColorSchemeArgumentType());
    }

    static ArgumentBuilder<CommandSource, ?> dyesSlotNames() {
        return Commands.func_197056_a((String)"dye_slot", (ArgumentType)new ListArgumentType(DYE_TYPES.keySet()));
    }

    static ArgumentBuilder<CommandSource, ?> dyeColor() {
        return Commands.func_197056_a((String)"color", (ArgumentType)new ColorArgumentType());
    }

    static ArgumentBuilder<CommandSource, ?> textInput(String key) {
        return Commands.func_197056_a((String)key, (ArgumentType)ComponentArgumentType.textComponent());
    }

    static ArgumentBuilder<CommandSource, ?> nbtInput(String key) {
        return Commands.func_197056_a((String)key, (ArgumentType)NBTCompoundTagArgument.func_218043_a());
    }

    static ArgumentBuilder<CommandSource, ?> scale() {
        return Commands.func_197056_a((String)"scale", (ArgumentType)FloatArgumentType.floatArg());
    }

    static ArgumentBuilder<CommandSource, ?> outputFileName() {
        return Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<CommandSource, ?> resizableSlotAmounts() {
        return Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<CommandSource, ?> resizableSlotNames() {
        return Commands.func_197056_a((String)"slot_name", (ArgumentType)new ListArgumentType(ObjectUtils.compactMap(SkinSlotType.values(), slotType -> {
            if (slotType.isResizable()) {
                return slotType.getName();
            }
            return null;
        })));
    }

    static ArgumentBuilder<CommandSource, ?> slotNames() {
        return Commands.func_197056_a((String)"slot_name", (ArgumentType)new ListArgumentType(ObjectUtils.map(SkinSlotType.values(), SkinSlotType::getName)));
    }

    static ArgumentBuilder<CommandSource, ?> overrideTypes() {
        return Commands.func_197056_a((String)"skin_type", (ArgumentType)new ListArgumentType(ObjectUtils.map(ItemOverrideType.values(), ItemOverrideType::getName)));
    }

    static ArgumentBuilder<CommandSource, ?> skins() {
        return Commands.func_197056_a((String)"skin", (ArgumentType)new FileArgumentType(EnvironmentManager.getSkinLibraryDirectory()));
    }

    static ArgumentBuilder<CommandSource, ?> addOrRemote() {
        return Commands.func_197056_a((String)"operator", (ArgumentType)new ListArgumentType(Lists.newArrayList((Object[])new String[]{"add", "remove"})));
    }

    private static class Executor {
        private Executor() {
        }

        static int reloadLibrary(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinLibraryManager.getServer().start();
            return 0;
        }

        static boolean containsNode(CommandContext<CommandSource> context, String name) {
            for (ParsedCommandNode node : context.getNodes()) {
                if (!name.equals(node.getNode().getName())) continue;
                return true;
            }
            return false;
        }

        static int setColor(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ISkinPaintType paintType = (ISkinPaintType)DYE_TYPES.get(ListArgumentType.getString(context, "dye_slot"));
            if (paintType == null) {
                throw ERROR_MISSING_DYE_SLOT.create(null);
            }
            PaintColor paintColor = ColorArgumentType.getColor(context, "color");
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                int slot = SkinSlotType.getDyeSlotIndex(paintType);
                ItemStack itemStack = new ItemStack((IItemProvider)ModItems.BOTTLE.get());
                ColorUtils.setColor(itemStack, paintColor);
                IInventory inventory = wardrobe.getInventory();
                inventory.func_70299_a(slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int giveSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            if (descriptor.isEmpty()) {
                return 0;
            }
            ItemStack itemStack = descriptor.asItemStack();
            for (PlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
                SkinUtils.giveTo(itemStack, player);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.give.success.single", 1, itemStack.func_151000_E(), player.func_145748_c_()), true);
            }
            return 1;
        }

        static int setSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            if (descriptor.isEmpty()) {
                return 0;
            }
            ItemStack itemStack = descriptor.asItemStack();
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                SkinSlotType slotType = SkinSlotType.of(descriptor.getType());
                if (slotType == null || wardrobe == null) continue;
                int slot = wardrobe.getFreeSlot(slotType);
                if (Executor.containsNode(context, "slot")) {
                    slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
                }
                wardrobe.setItem(slotType, slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int clearSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                if (!Executor.containsNode(context, "slot")) {
                    wardrobe.clear();
                    wardrobe.broadcast();
                    continue;
                }
                int slot = IntegerArgumentType.getInteger(context, (String)"slot");
                SkinSlotType slotType = SkinSlotType.of(ListArgumentType.getString(context, "slot_name"));
                if (slotType == null) continue;
                wardrobe.setItem(slotType, slot - 1, ItemStack.field_190927_a);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int exportSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            String format = ListArgumentType.getString(context, "format");
            String filename = StringArgumentType.getString(context, (String)"name");
            float scale = 1.0f;
            if (Executor.containsNode(context, "scale")) {
                scale = FloatArgumentType.getFloat(context, (String)"scale");
            }
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ItemStack itemStack = player.func_184614_ca();
            String identifier = SkinDescriptor.of(itemStack).getIdentifier();
            Skin skin = SkinLoader.getInstance().loadSkin(identifier);
            if (skin == null) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            float resolvedScale = scale;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("Skin", identifier);
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.processing", filename));
            UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.processing", new Object[0]), tag, (PlayerEntity)player);
            Util.func_215072_e().execute(() -> Executor.lambda$exportSkin$0(skin, format, filename, resolvedScale, (PlayerEntity)player, tag));
            return 0;
        }

        static int setItemSkinnable(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            String operator = ListArgumentType.getString(context, "operator");
            ItemOverrideType overrideType = ItemOverrideType.of(ListArgumentType.getString(context, "skin_type"));
            ItemStack itemStack = player.func_184614_ca();
            if (overrideType == null || itemStack.func_190926_b()) {
                throw ERROR_MISSING_ITEM_STACK.create((Object)player.func_195047_I_());
            }
            ResourceLocation identifier = RegistryManager.getKey(itemStack.func_77973_b());
            String key = String.format("%s:%s", overrideType.getName(), identifier);
            if (operator.equals("add")) {
                if (ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.add(key);
            } else {
                if (!ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.remove(key);
            }
            ModConfigSpec.COMMON.save();
            String messageKey = "commands.armourers_workshop.armourers.setItemSkinnable." + operator;
            IFormattableTextComponent overrideTypeName = TranslateUtils.Name.of(overrideType);
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, messageKey, itemStack.func_151000_E(), overrideTypeName));
            return 1;
        }

        static int resyncWardrobe(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (ServerPlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
                SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
                if (wardrobe == null) continue;
                wardrobe.broadcast();
            }
            return 1;
        }

        static int openWardrobe(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                MenuManager.openMenu(ModMenuTypes.WARDROBE_OP, (PlayerEntity)player, wardrobe);
                break;
            }
            return 1;
        }

        static int sendToastNotify(CommandContext<CommandSource> context) throws CommandSyntaxException {
            return Executor.sendUserNotify(context, Integer.MIN_VALUE);
        }

        static int sendAlertNotify(CommandContext<CommandSource> context) throws CommandSyntaxException {
            return Executor.sendUserNotify(context, 0);
        }

        static int sendUserNotify(CommandContext<CommandSource> context, int type) throws CommandSyntaxException {
            ITextComponent message1 = ComponentArgumentType.getComponent(context, "message");
            IFormattableTextComponent title1 = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.title", new Object[0]);
            IFormattableTextComponent confirm1 = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.confirm", new Object[0]);
            CompoundNBT icon1 = null;
            if (Executor.containsNode(context, "title")) {
                title1 = ComponentArgumentType.getComponent(context, "title");
            }
            if (Executor.containsNode(context, "confirm")) {
                confirm1 = ComponentArgumentType.getComponent(context, "confirm");
            }
            if (Executor.containsNode(context, "icon")) {
                icon1 = NBTCompoundTagArgument.func_218042_a(context, (String)"icon");
            }
            for (ServerPlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
                NetworkManager.sendTo(new ExecuteAlertPacket((ITextComponent)title1, message1, (ITextComponent)confirm1, type, icon1), player);
            }
            return 1;
        }

        static int setUnlockedWardrobeSlots(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.of(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int amount = IntegerArgumentType.getInteger(context, (String)"amount");
                wardrobe.setUnlockedSize(slotType, MathUtils.clamp(amount, 0, slotType.getMaxSize()));
                wardrobe.broadcast();
            }
            return 1;
        }

        static SkinDescriptor loadSkinDescriptor(CommandContext<CommandSource> context) {
            String identifier = FileArgumentType.getString(context, "skin");
            if (identifier.isEmpty()) {
                return SkinDescriptor.EMPTY;
            }
            ColorScheme scheme = ColorScheme.EMPTY;
            if (Executor.containsNode(context, "dying")) {
                scheme = ColorSchemeArgumentType.getColorScheme(context, "dying");
            }
            boolean needCopy = false;
            if (identifier.startsWith("/")) {
                identifier = DataDomain.DEDICATED_SERVER.normalize(identifier);
                needCopy = true;
            }
            return SkinLoader.getInstance().loadSkinFromDB(identifier, scheme, needCopy);
        }

        private static /* synthetic */ void lambda$exportSkin$0(Skin skin, String format, String filename, float resolvedScale, PlayerEntity player, CompoundNBT tag) {
            try {
                SkinExportManager.exportSkin(skin, format, filename, resolvedScale);
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.success", filename));
                UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.success", new Object[0]), tag, player);
            }
            catch (Exception e) {
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.failure", filename));
                UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.failure", new Object[0]), tag, player);
                e.printStackTrace();
            }
        }
    }
}

