/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class PlayerTextureDescriptor {
    public static final PlayerTextureDescriptor EMPTY = new PlayerTextureDescriptor();
    private static final Cache<ItemStack, PlayerTextureDescriptor> DESCRIPTOR_CACHES = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(15L, TimeUnit.SECONDS).build();
    private Source source;
    private String url;
    private GameProfile profile;

    public PlayerTextureDescriptor() {
        this.source = Source.NONE;
    }

    public PlayerTextureDescriptor(String url) {
        this.source = Source.URL;
        this.url = url;
    }

    public PlayerTextureDescriptor(GameProfile profile) {
        this.source = Source.USER;
        this.profile = profile;
    }

    public PlayerTextureDescriptor(@Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_150297_b("URL", 8)) {
            this.source = Source.URL;
            this.url = nbt.func_74779_i("URL");
        }
        if (nbt != null && nbt.func_150297_b("User", 10)) {
            this.source = Source.USER;
            this.profile = OptionalAPI.getOptionalGameProfile(nbt, "User", null);
        }
        if (this.url == null && this.profile == null) {
            this.source = Source.NONE;
        }
    }

    public static PlayerTextureDescriptor by(String userName) {
        return EMPTY;
    }

    public static PlayerTextureDescriptor of(ItemStack itemStack) {
        if (!ABI.is(itemStack, (Item)ModItems.MANNEQUIN.get())) {
            return EMPTY;
        }
        CompoundNBT entityTag = itemStack.func_179543_a("EntityTag");
        if (entityTag == null || !entityTag.func_150297_b("Texture", 10)) {
            return EMPTY;
        }
        PlayerTextureDescriptor descriptor = (PlayerTextureDescriptor)DESCRIPTOR_CACHES.getIfPresent((Object)itemStack);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new PlayerTextureDescriptor(entityTag.func_74775_l("Texture"));
        DESCRIPTOR_CACHES.put((Object)itemStack, (Object)descriptor);
        return descriptor;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.url != null) {
            nbt.func_74778_a("URL", this.url);
        }
        if (this.profile != null) {
            OptionalAPI.putOptionalGameProfile(nbt, "User", this.profile, null);
        }
        return nbt;
    }

    public boolean isEmpty() {
        return this.source == Source.NONE;
    }

    @Nullable
    public String getURL() {
        return this.url;
    }

    @Nullable
    public String getName() {
        if (this.profile != null) {
            return this.profile.getName();
        }
        return null;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public Source getSource() {
        return this.source;
    }

    public String getValue() {
        if (this.source == Source.URL) {
            return this.getURL();
        }
        if (this.source == Source.USER) {
            return this.getName();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerTextureDescriptor that = (PlayerTextureDescriptor)o;
        return this.source == that.source && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.getValue()});
    }

    public static enum Source {
        NONE,
        USER,
        URL;

    }
}

