/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.blockbench;

import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchModelUV;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchTexture;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Size2f;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimation;
import moe.plushie.armourers_workshop.utils.texture.TextureData;
import moe.plushie.armourers_workshop.utils.texture.TextureProperties;
import net.minecraft.util.Direction;

public class BlockBenchModelTexture
extends BedrockModelTexture {
    private final Size2f resolution;
    private final List<BlockBenchTexture> inputs;
    private final HashMap<Integer, TextureData> allTexture = new HashMap();
    private final HashMap<String, TextureData> loadedTextures = new HashMap();
    protected TextureData defaultTextureData;

    public BlockBenchModelTexture(Size2f resolution, List<BlockBenchTexture> textureInputs) {
        this.resolution = resolution;
        this.inputs = textureInputs;
    }

    public void load(HashSet<Integer> usedTextureIds) throws IOException {
        if (this.defaultTextureData != null) {
            return;
        }
        for (int textureId : usedTextureIds) {
            BlockBenchTexture additionalTexture;
            if (textureId < 0 || textureId >= this.inputs.size()) continue;
            BlockBenchTexture texture = this.inputs.get(textureId);
            TextureData data = this.loadTextureData(texture);
            this.allTexture.put(textureId, data);
            if (this.defaultTextureData == null) {
                this.defaultTextureData = data;
            }
            if ((additionalTexture = this.getAdditionalTexture(texture)) == null) continue;
            TextureData variant = this.loadTextureData(additionalTexture);
            variant.getProperties().setEmissive(true);
            data.setVariants(Collections.singleton(variant));
        }
        this.textureData = this.defaultTextureData;
        if (this.textureData == null) {
            throw new IOException("error.bb.loadModel.noTexture");
        }
    }

    @Override
    protected TextureData getTextureData(BedrockModelCube cube) {
        BlockBenchModelUV uv1 = ObjectUtils.safeCast(cube.getUV(), BlockBenchModelUV.class);
        if (uv1 != null) {
            return this.allTexture.get(uv1.getDefaultTextureId());
        }
        return null;
    }

    @Override
    protected TextureData getTextureData(BedrockModelCube cube, Direction dir) {
        BlockBenchModelUV uv1 = ObjectUtils.safeCast(cube.getUV(), BlockBenchModelUV.class);
        if (uv1 != null) {
            return this.allTexture.get(uv1.getTextureId(dir));
        }
        return null;
    }

    private BlockBenchTexture getAdditionalTexture(BlockBenchTexture texture) {
        String name = texture.getName();
        for (BlockBenchTexture input : this.inputs) {
            String target = input.getName();
            if (name.length() >= target.length() || !name.equals(target.replaceAll("(?i)_s", ""))) continue;
            return input;
        }
        return null;
    }

    private TextureData loadTextureData(BlockBenchTexture texture) throws IOException {
        TextureData textureData = this.loadedTextures.get(texture.getUUID());
        if (textureData != null) {
            return textureData;
        }
        String str = texture.getSource();
        String[] parts = str.split(";base64,");
        if (parts.length != 2) {
            throw new IOException("error.bb.loadModel.textureNotSupported");
        }
        byte[] imageBytes = Base64.getDecoder().decode(parts[1]);
        int imageFrame = this.resolveTextureFrame(imageBytes);
        Size2f size = this.resolveTextureSize(imageFrame);
        TextureAnimation animation = this.resolveTextureAnimation(texture, imageFrame);
        TextureProperties properties = texture.getProperties();
        textureData = new TextureData(texture.getName(), size.getWidth(), size.getHeight(), animation, properties);
        textureData.load(Unpooled.wrappedBuffer((byte[])imageBytes));
        this.loadedTextures.put(texture.getUUID(), textureData);
        return textureData;
    }

    private int resolveTextureFrame(byte[] imageBytes) throws IOException {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
        int width = image.getWidth();
        int height = image.getHeight();
        int frame = height / width;
        if (frame * width == height) {
            return frame;
        }
        return 0;
    }

    private Size2f resolveTextureSize(int frameCount) {
        float width = this.resolution.getWidth();
        float height = this.resolution.getHeight();
        if (frameCount > 1) {
            height = width * (float)frameCount;
        }
        return new Size2f(width, height);
    }

    private TextureAnimation resolveTextureAnimation(BlockBenchTexture texture, int frameCount) {
        if (frameCount > 1) {
            int time = texture.getFrameTime() * 50;
            boolean interpolate = texture.getFrameInterpolate();
            TextureAnimation.Mode mode = texture.getFrameMode();
            return new TextureAnimation(time, frameCount, mode, interpolate);
        }
        return TextureAnimation.EMPTY;
    }
}

