/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;

public class BedrockModel {
    private final String formatVersion;
    private final Collection<BedrockModelGeometry> geometries;

    public BedrockModel(String formatVersion, Collection<BedrockModelGeometry> geometries) {
        this.formatVersion = formatVersion;
        this.geometries = geometries;
    }

    public Collection<BedrockModelGeometry> getGeometries() {
        return this.geometries;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public static class Builder {
        private String formatVersion;
        private final ArrayList<BedrockModelGeometry> geometries = new ArrayList();

        public void formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public void addGeometry(BedrockModelGeometry geometry) {
            this.geometries.add(geometry);
        }

        public BedrockModel build() {
            return new BedrockModel(this.formatVersion, this.geometries);
        }
    }
}

