/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import moe.plushie.armourers_workshop.api.common.IResource;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPack;
import moe.plushie.armourers_workshop.core.skin.transformer.SkinPackReader;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModel;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelBone;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelExporter;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelTexture;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockTransform;
import moe.plushie.armourers_workshop.core.skin.transformer.blockbench.BlockBenchReader;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public final class SkinSerializerV21 {
    public static Skin readSkinFromFile(File file) throws IOException {
        String name = file.getName();
        Collection<IResource> resources = SkinSerializerV21.getResourcesFromFile(file);
        return SkinSerializerV21.readSkinFromReader(BlockBenchReader.from(name, resources));
    }

    public static Skin readSkinFromReader(SkinPackReader reader) throws IOException {
        BedrockModelExporter exporter = new BedrockModelExporter();
        reader.loadEntityModel(modelReader -> {
            Map<String, BedrockTransform> transforms;
            BedrockModel model = modelReader.readModel();
            for (BedrockModelGeometry geometry : model.getGeometries()) {
                BedrockModelTexture texture = modelReader.readTexture(geometry);
                for (BedrockModelBone bone : geometry.getBones()) {
                    exporter.add(bone, texture);
                }
            }
            SkinPack pack = modelReader.getPack();
            if (pack != null) {
                List<String> authors;
                String description;
                String name2 = pack.getName();
                if (name2 != null && !name2.isEmpty()) {
                    exporter.add(SkinProperty.ALL_CUSTOM_NAME, name2);
                }
                if ((description = pack.getDescription()) != null && !description.isEmpty()) {
                    exporter.add(SkinProperty.ALL_FLAVOUR_TEXT, description);
                }
                if ((authors = pack.getAuthors()) != null && !authors.isEmpty()) {
                    StringBuilder builder = null;
                    for (String a : authors) {
                        if (builder == null) {
                            builder = new StringBuilder(a);
                            continue;
                        }
                        builder.append(",");
                        builder.append(a);
                    }
                    exporter.add(SkinProperty.ALL_AUTHOR_NAME, builder.toString());
                }
            }
            if ((transforms = modelReader.getTransforms()) != null) {
                transforms.forEach((name, transform) -> {
                    Vector3f scale;
                    Vector3f rotation;
                    Vector3f translation = transform.getTranslation();
                    SkinTransform transform1 = SkinTransform.create(translation, rotation = transform.getRotation(), scale = transform.getScale());
                    if (!transform1.isIdentity()) {
                        exporter.add((String)name, transform1);
                    }
                });
            }
        });
        ISkinType skinType = SkinTypes.ITEM_SWORD;
        if (skinType == SkinTypes.OUTFIT) {
            exporter.move(new Vector3f(0.0f, -24.0f, 0.0f));
            exporter.add(SkinProperty.OVERRIDE_MODEL_HEAD, true);
            exporter.add(SkinProperty.OVERRIDE_MODEL_CHEST, true);
            exporter.add(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, true);
            exporter.add(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, true);
            exporter.add(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
            exporter.add(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_HAT, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_JACKET, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
            exporter.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
            exporter.add(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, true);
            exporter.add(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, true);
            exporter.add(SkinProperty.OVERRIDE_EQUIPMENT_HELMET, true);
            exporter.add(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, true);
        }
        return exporter.export(skinType);
    }

    private static Collection<IResource> getResourcesFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            return SkinSerializerV21.getResourcesFromDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return SkinSerializerV21.getResourcesFromZip(file);
        }
        return SkinSerializerV21.getResourcesFromSet(file);
    }

    private static Collection<IResource> getResourcesFromZip(File zipFile) throws IOException {
        ZipEntry entry;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        final ZipFile file = new ZipFile(zipFile);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            final ZipEntry fileEntry = entry;
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return file.getInputStream(fileEntry);
                }
            });
        }
        return resources;
    }

    private static Collection<IResource> getResourcesFromDirectory(File rootPath) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : SkinFileUtils.listAllFiles(rootPath)) {
            if (entry.isDirectory()) continue;
            final String fileName = SkinFileUtils.getRelativePath(entry, rootPath, true).substring(1);
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    private static Collection<IResource> getResourcesFromSet(File ... entries) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : entries) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }
}

