/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class ChunkTransform {
    private static final float[] IDENTITY_MATRIX_BUFFER = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] IDENTITY_VECTOR_BUFFER = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private Vector3f translate;
    private Vector3f rotation;
    private Vector3f scale;
    private Vector3f offset;
    private Vector3f pivot;
    private FloatBuffer buffer;

    public ChunkTransform() {
    }

    public ChunkTransform(SkinTransform transform) {
        if (transform.isIdentity()) {
            this.setIdentity();
            return;
        }
        this.translate = transform.getTranslate();
        this.rotation = transform.getRotation();
        this.scale = transform.getScale();
        this.offset = transform.getOffset();
        this.pivot = transform.getPivot();
    }

    public ChunkTransform(FloatBuffer buffer) {
        this.buffer = buffer;
    }

    public static ChunkTransform of(ISkinTransform transform) {
        if (transform instanceof SkinTransform) {
            return new ChunkTransform((SkinTransform)transform);
        }
        return ChunkTransform.flat(transform);
    }

    public static ChunkTransform flat(ISkinTransform transform) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        OpenPoseStack poseStack = new OpenPoseStack();
        transform.apply(poseStack);
        poseStack.lastPose().store(buffer);
        return new ChunkTransform(buffer);
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        byte flags = stream.readByte();
        if ((flags & 0x10) != 0) {
            this.setIdentity();
            return;
        }
        if ((flags & 0x20) != 0) {
            this.buffer = FloatBuffer.allocate(16);
            ChunkTransform.readZippedBuffer(stream, this.buffer, IDENTITY_MATRIX_BUFFER);
            return;
        }
        FloatBuffer buffer = FloatBuffer.allocate(IDENTITY_VECTOR_BUFFER.length);
        ChunkTransform.readZippedBuffer(stream, buffer, IDENTITY_VECTOR_BUFFER);
        this.translate = ChunkTransform.readVector(buffer, 0);
        this.rotation = ChunkTransform.readVector(buffer, 3);
        this.scale = ChunkTransform.readVector(buffer, 6);
        this.offset = ChunkTransform.readVector(buffer, 9);
        this.pivot = ChunkTransform.readVector(buffer, 12);
    }

    public void writeToStream(ChunkOutputStream stream) throws IOException {
        if (this.isIdentity()) {
            stream.writeByte(16);
            return;
        }
        if (this.buffer != null) {
            stream.writeByte(32);
            ChunkTransform.writeZippedBuffer(stream, this.buffer, IDENTITY_MATRIX_BUFFER);
            return;
        }
        stream.writeByte(64);
        FloatBuffer buffer = FloatBuffer.allocate(IDENTITY_VECTOR_BUFFER.length);
        buffer.put(this.translate.getX()).put(this.translate.getY()).put(this.translate.getZ());
        buffer.put(this.rotation.getX()).put(this.rotation.getY()).put(this.rotation.getZ());
        buffer.put(this.scale.getX()).put(this.scale.getY()).put(this.scale.getZ());
        buffer.put(this.offset.getX()).put(this.offset.getY()).put(this.offset.getZ());
        buffer.put(this.pivot.getX()).put(this.pivot.getY()).put(this.pivot.getZ());
        buffer.rewind();
        ChunkTransform.writeZippedBuffer(stream, buffer, IDENTITY_VECTOR_BUFFER);
    }

    public void setIdentity() {
        this.pivot = null;
        this.translate = null;
        this.scale = null;
        this.rotation = null;
        this.buffer = null;
    }

    public boolean isIdentity() {
        return this.buffer == null && this.scale == null;
    }

    public ISkinTransform build() {
        if (this.isIdentity()) {
            return SkinTransform.IDENTITY;
        }
        if (this.buffer != null) {
            OpenMatrix4f pose = new OpenMatrix4f(this.buffer);
            OpenMatrix3f normal = new OpenMatrix3f(this.buffer);
            return new FlatTransform(pose, normal);
        }
        return SkinTransform.create(this.translate, this.rotation, this.scale, this.pivot, this.offset);
    }

    private static Vector3f readVector(FloatBuffer buffer, int offset) {
        float x = buffer.get(offset);
        float y = buffer.get(offset + 1);
        float z = buffer.get(offset + 2);
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return Vector3f.ZERO;
        }
        if (x == 1.0f && y == 1.0f && z == 1.0f) {
            return Vector3f.ONE;
        }
        return new Vector3f(x, y, z);
    }

    private static void readZippedBuffer(ChunkInputStream stream, FloatBuffer bufferOut, float[] bufferDef) throws IOException {
        short flags = stream.readShort();
        for (int i = 0; i < bufferDef.length; ++i) {
            if ((flags & 1 << i) == 0) {
                bufferOut.put(i, stream.readFloat());
                continue;
            }
            bufferOut.put(i, bufferDef[i]);
        }
        bufferOut.rewind();
    }

    private static void writeZippedBuffer(ChunkOutputStream stream, FloatBuffer bufferIn, float[] bufferDef) throws IOException {
        int i;
        int flags = 0;
        for (i = 0; i < bufferDef.length; ++i) {
            if (bufferDef[i] != bufferIn.get(i)) continue;
            flags |= 1 << i;
        }
        stream.writeShort(flags);
        for (i = 0; i < bufferDef.length; ++i) {
            if ((flags & 1 << i) != 0) continue;
            stream.writeFloat(bufferIn.get(i));
        }
    }

    public static class FlatTransform
    implements ISkinTransform {
        private final OpenMatrix4f pose;
        private final OpenMatrix3f normal;

        public FlatTransform(OpenMatrix4f pose, OpenMatrix3f normal) {
            this.pose = pose;
            this.normal = normal;
        }

        @Override
        public void pre(IPoseStack poseStack) {
        }

        @Override
        public void post(IPoseStack poseStack) {
            poseStack.multiply(this.normal);
            poseStack.multiply(this.pose);
        }
    }
}

