/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.ISkinSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializers;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeCoders;
import org.apache.commons.lang3.tuple.Pair;

public final class SkinSerializerV20
implements ISkinSerializer {
    public static final int FILE_HEADER = 1397442894;
    public static final int FILE_VERSION = 20;
    public static final int MAX_FILE_VERSION = 20;

    @Override
    public void writeToStream(Skin skin, IOutputStream stream, int fileVersion) throws IOException {
        stream.writeInt(skin.getVersion());
        stream.writeInt(0);
        stream.writeInt(0);
        ChunkContext context = ChunkCubeCoders.createEncodeContext(skin);
        ChunkSerializers.writeToStream(skin, stream, context);
        stream.writeInt(0);
    }

    @Override
    public Skin readFromStream(IInputStream stream, int fileVersion) throws IOException {
        fileVersion = stream.readInt();
        stream.readInt();
        stream.readInt();
        ChunkContext context = ChunkCubeCoders.createDecodeContext(fileVersion);
        return ChunkSerializers.readFromStream(stream, context);
    }

    @Override
    public SkinFileHeader readInfoFromStream(IInputStream stream, int fileVersion) throws IOException {
        fileVersion = stream.readInt();
        stream.readInt();
        stream.readInt();
        ChunkContext context = ChunkCubeCoders.createDecodeContext(fileVersion);
        Pair<ISkinType, ISkinProperties> pair = ChunkSerializers.readInfoFromStream(stream, context);
        return SkinFileHeader.of(fileVersion, (ISkinType)pair.getKey(), (ISkinProperties)pair.getValue());
    }

    @Override
    public int getSupportedVersion() {
        return 1397442894;
    }
}

