/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.io;

import io.netty.buffer.ByteBuf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimation;
import moe.plushie.armourers_workshop.utils.texture.TextureProperties;

public interface IOutputStream {
    public static IOutputStream of(DataOutputStream stream) {
        return () -> stream;
    }

    public DataOutputStream getOutputStream();

    default public void write(byte[] bytes) throws IOException {
        this.getOutputStream().write(bytes);
    }

    default public void write(byte[] b, int off, int len) throws IOException {
        this.getOutputStream().write(b, off, len);
    }

    default public void writeBytes(ByteBuf buf) throws IOException {
        this.writeBytes(buf, buf.readableBytes());
    }

    default public void writeBytes(ByteBuf buf, int limit) throws IOException {
        buf.getBytes(0, (OutputStream)this.getOutputStream(), limit);
    }

    default public void writeBytes(ByteBuffer buf) throws IOException {
        WritableByteChannel channel = Channels.newChannel(this.getOutputStream());
        channel.write(buf.duplicate());
    }

    default public void writeByte(int v) throws IOException {
        this.getOutputStream().writeByte(v);
    }

    default public void writeBoolean(boolean v) throws IOException {
        this.getOutputStream().writeBoolean(v);
    }

    default public void writeShort(int v) throws IOException {
        this.getOutputStream().writeShort(v);
    }

    default public void writeInt(int v) throws IOException {
        this.getOutputStream().writeInt(v);
    }

    default public void writeLong(long v) throws IOException {
        this.getOutputStream().writeLong(v);
    }

    default public void writeFloat(float v) throws IOException {
        this.getOutputStream().writeFloat(v);
    }

    default public void writeDouble(double v) throws IOException {
        this.getOutputStream().writeDouble(v);
    }

    default public void writeString(String v) throws IOException {
        if (v == null || v.isEmpty()) {
            this.getOutputStream().writeShort(0);
            return;
        }
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        int size = bytes.length;
        if (size > 65535) {
            throw new IOException("String is over the max length allowed.");
        }
        this.getOutputStream().writeShort((short)size);
        this.getOutputStream().write(bytes);
    }

    default public void writeString(String v, int len) throws IOException {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        this.getOutputStream().write(bytes, 0, len);
    }

    default public void writeVarInt(int i) throws IOException {
        DataOutputStream outputStream = this.getOutputStream();
        while (true) {
            if ((i & 0xFFFFFF80) == 0) break;
            outputStream.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        outputStream.writeByte(i);
    }

    default public void writeVector3i(IVector3i vec) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeInt(vec.getX());
        stream.writeInt(vec.getY());
        stream.writeInt(vec.getZ());
    }

    default public void writeVector3f(IVector3f vec) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeFloat(vec.getX());
        stream.writeFloat(vec.getY());
        stream.writeFloat(vec.getZ());
    }

    default public void writeRectangle3i(IRectangle3i rect) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeInt(rect.getX());
        stream.writeInt(rect.getY());
        stream.writeInt(rect.getZ());
        stream.writeInt(rect.getWidth());
        stream.writeInt(rect.getHeight());
        stream.writeInt(rect.getDepth());
    }

    default public void writeRectangle3f(IRectangle3f rect) throws IOException {
        DataOutputStream stream = this.getOutputStream();
        stream.writeFloat(rect.getX());
        stream.writeFloat(rect.getY());
        stream.writeFloat(rect.getZ());
        stream.writeFloat(rect.getWidth());
        stream.writeFloat(rect.getHeight());
        stream.writeFloat(rect.getDepth());
    }

    default public void writeTransformf(ITransformf transform) throws IOException {
        if (transform instanceof SkinTransform) {
            ((SkinTransform)transform).writeToStream(this);
        }
    }

    default public void writeSkinProperties(SkinProperties properties) throws IOException {
        properties.writeToStream(this);
    }

    default public void writeTextureAnimation(TextureAnimation animation) throws IOException {
        animation.writeToStream(this);
    }

    default public void writeTextureProperties(TextureProperties properties) throws IOException {
        properties.writeToStream(this);
    }

    default public void writeType(IRegistryEntry type) throws IOException {
        this.writeString(type.getRegistryName().toString());
    }
}

