/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part.bow;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;

public class BowPartType
extends SkinPartType
implements ICanHeld,
ICanUse {
    private final int frame;
    private final Range<Integer> useRange;

    public BowPartType(int frame) {
        this.frame = frame;
        this.buildingSpace = new Rectangle3i(-12, -42, -46, 24, 84, 64);
        this.guideSpace = new Rectangle3i(-2, -2, 2, 4, 4, 8);
        this.offset = BowPartType.getFrameOffset(frame);
        this.useRange = BowPartType.getFrameUseRange(frame);
    }

    public static Range<Integer> getFrameUseRange(int frame) {
        switch (frame) {
            case 0: {
                return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
            }
            case 1: {
                return Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));
            }
            case 2: {
                return Range.closed((Comparable)Integer.valueOf(13), (Comparable)Integer.valueOf(17));
            }
        }
        return Range.closed((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(30));
    }

    public static Vector3i getFrameOffset(int frame) {
        switch (frame) {
            case 0: {
                return new Vector3i(-50, 0, 0);
            }
            case 1: {
                return new Vector3i(-25, 0, 0);
            }
            case 2: {
                return new Vector3i(0, 0, 0);
            }
            case 3: {
                return new Vector3i(25, 0, 0);
            }
        }
        return null;
    }

    @Override
    public Range<Integer> getUseRange() {
        return this.useRange;
    }

    @Override
    public int getMinimumMarkersNeeded() {
        return 1;
    }

    @Override
    public int getMaximumMarkersNeeded() {
        return 1;
    }

    @Override
    public boolean isPartRequired() {
        return this.frame != 0;
    }
}

