/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.exporter;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.skin.ISkinExporter;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.exporter.SkinExporterPolygon;
import moe.plushie.armourers_workshop.core.skin.exporter.SkinExporterWavefrontObj;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;

public final class SkinExportManager {
    public static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("#.#####");
    public static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#.############");
    private static final ArrayList<ISkinExporter> SKIN_EXPORTERS = new ArrayList();

    public static ISkinExporter getSkinExporter(String fileExtension) {
        if (fileExtension.isEmpty()) {
            return null;
        }
        for (ISkinExporter skinExporter : SKIN_EXPORTERS) {
            for (String ext : skinExporter.getExtensions()) {
                if (!ext.equalsIgnoreCase(fileExtension)) continue;
                return skinExporter;
            }
        }
        return null;
    }

    public static void exportSkin(Skin skin, String fileExtension, String filename, float scale) throws Exception {
        ISkinExporter skinExporter = SkinExportManager.getSkinExporter(fileExtension);
        if (skinExporter != null) {
            SkinExportManager.exportSkin(skin, skinExporter, filename, scale);
        } else {
            ModLog.error("Could not export to {} format.", fileExtension);
        }
    }

    public static void exportSkin(Skin skin, ISkinExporter skinExporter, String filename, float scale) throws Exception {
        File filePath = new File(EnvironmentManager.getRootDirectory(), "model-exports");
        SkinFileUtils.forceMkdir(filePath);
        skinExporter.exportSkin(skin, filePath, filename, scale);
    }

    public static Collection<String> getExporters() {
        ArrayList<String> exporters = new ArrayList<String>();
        for (ISkinExporter skinExporter : SKIN_EXPORTERS) {
            exporters.addAll(skinExporter.getExtensions());
        }
        return exporters;
    }

    static {
        SKIN_EXPORTERS.add(new SkinExporterWavefrontObj());
        SKIN_EXPORTERS.add(new SkinExporterPolygon());
    }
}

