/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV2;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentCollider;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.exception.SkinSaveException;
import moe.plushie.armourers_workshop.core.skin.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.Nullable;

public class SkinDocumentExporter {
    private final SkinDocument document;
    private SkinItemTransforms itemTransforms;
    private final HashMap<String, Skin> skins = new HashMap();

    public SkinDocumentExporter(SkinDocument document) {
        this.document = document;
    }

    public Skin execute(PlayerEntity player) throws TranslatableException {
        ISkinType skinType = this.document.getType().getSkinType();
        SkinSettings settings = new SkinSettings();
        SkinProperties properties = this.document.getProperties().copy();
        ArrayList<SkinPart> parts = this.convertToParts(this.document.getRoot());
        if (parts.isEmpty()) {
            throw SkinSaveException.Type.NO_DATA.build("noting", new Object[0]);
        }
        if (skinType == SkinTypes.BLOCK) {
            HashMap<Vector3i, Rectangle3i> boxes = SkinDocumentCollider.generateCollisionBox(this.document.getRoot());
            settings.setCollisionBox(new ArrayList<Rectangle3i>(boxes.values()));
            if (properties.get(SkinProperty.BLOCK_BED).booleanValue() && properties.get(SkinProperty.BLOCK_SEAT).booleanValue()) {
                throw SkinSaveException.Type.BED_AND_SEAT.build("conflictBedSeat", new Object[0]);
            }
            if (properties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue() && !boxes.containsKey(Vector3i.ZERO)) {
                throw SkinSaveException.Type.INVALID_MULTIBLOCK.build("missingMainBlock", new Object[0]);
            }
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        settings.setEditable(false);
        settings.setItemTransforms(this.itemTransforms);
        builder.version(20);
        builder.settings(settings);
        builder.properties(properties);
        builder.parts(parts);
        builder.previewData(null);
        builder.blobs(null);
        return builder.build();
    }

    private ArrayList<SkinPart> convertToParts(SkinDocumentNode parent) throws TranslatableException {
        ArrayList<SkinPart> allParts = new ArrayList<SkinPart>();
        for (SkinDocumentNode node : parent.children()) {
            if (!node.isEnabled()) continue;
            Skin skin = this.loadSkin(node);
            List<SkinPart> using = this.loadSkinParts(skin, node);
            SkinTransform transform = node.getTransform();
            ArrayList<SkinPart> parts = this.convertToParts(node);
            if (using == null && parts.isEmpty()) continue;
            if (using != null && node.getType() == using.get(0).getType() && parts.isEmpty() && transform.isIdentity()) {
                SkinPart part = using.get(0);
                SkinPart.Builder builder = new SkinPart.Builder(node.getType());
                builder.name(node.getName());
                builder.transform(part.getTransform());
                builder.cubes(part.getCubeData());
                builder.markers(this.loadSkinMarkers(node));
                allParts.add(builder.build());
                this.loadItemTransforms(skin);
                continue;
            }
            SkinPart.Builder builder = new SkinPart.Builder(node.getType());
            builder.name(node.getName());
            builder.transform(transform);
            SkinCubesV2 cubes = new SkinCubesV2();
            builder.cubes(cubes);
            builder.markers(this.loadSkinMarkers(node));
            builder.properties(null);
            builder.blobs(null);
            SkinPart part = builder.build();
            if (using != null) {
                using.forEach(part::addPart);
                this.loadItemTransforms(skin);
            }
            parts.forEach(part::addPart);
            allParts.add(part);
        }
        return allParts;
    }

    @Nullable
    private List<SkinPart> loadSkinParts(Skin skin, SkinDocumentNode node) throws TranslatableException {
        List<SkinPart> parts;
        if (skin != null && !(parts = skin.getParts()).isEmpty()) {
            return parts;
        }
        return null;
    }

    @Nullable
    private Skin loadSkin(SkinDocumentNode node) throws TranslatableException {
        SkinDescriptor descriptor = node.getSkin();
        if (!descriptor.isEmpty()) {
            return this.loadSkin(node, descriptor);
        }
        return null;
    }

    private Skin loadSkin(SkinDocumentNode node, SkinDescriptor descriptor) throws TranslatableException {
        String identifier = descriptor.getIdentifier();
        Skin skin = this.skins.get(identifier);
        if (skin != null) {
            return skin;
        }
        skin = SkinLoader.getInstance().loadSkin(identifier);
        if (skin == null) {
            throw new TranslatableException("exception.armourers_workshop.load.notFoundNodePart", identifier, node.getName());
        }
        this.skins.put(identifier, skin);
        return skin;
    }

    private List<SkinMarker> loadSkinMarkers(SkinDocumentNode node) {
        ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
        for (SkinDocumentNode child : node.children()) {
            if (!child.isLocator()) continue;
            int x = -MathUtils.floor(child.getLocation().getX() * 16.0f);
            int y = -MathUtils.floor(child.getLocation().getY() * 16.0f);
            int z = MathUtils.floor(child.getLocation().getZ() * 16.0f);
            SkinMarker marker = new SkinMarker((byte)x, (byte)y, (byte)z, 0);
            markers.add(marker);
        }
        return markers;
    }

    private void loadItemTransforms(Skin skin) {
        SkinItemTransforms partItemTransforms = skin.getSettings().getItemTransforms();
        if (partItemTransforms != null) {
            if (this.itemTransforms == null) {
                this.itemTransforms = new SkinItemTransforms();
            }
            this.itemTransforms.putAll(partItemTransforms);
        }
    }
}

