/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public class SkinDocument {
    private SkinDocumentType type;
    private SkinDocumentNode nodes;
    private SkinProperties properties = new SkinProperties();
    private SkinDocumentSettings settings = new SkinDocumentSettings();
    private final SkinDocumentListeners.Proxy listener = new SkinDocumentListeners.Proxy();

    public SkinDocument() {
        this.setType(SkinDocumentTypes.GENERAL_ARMOR_HEAD);
    }

    public void reset() {
        this.setType(this.type);
    }

    public void setType(SkinDocumentType type) {
        this.type = type;
        this.nodes = this._generateDefaultNode(type);
        this.settings = this._generateSkinSettings();
        this.properties = this._generateSkinProperties();
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidChangeType(type);
    }

    public void serializeNBT(CompoundNBT tag) {
        OptionalAPI.putOptionalType(tag, "Type", this.type, null);
        tag.func_218657_a("Nodes", (INBT)this.nodes.serializeNBT());
        tag.func_218657_a("Settings", (INBT)this.settings.serializeNBT());
        OptionalAPI.putOptionalSkinProperties(tag, "Properties", this.properties);
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.type = OptionalAPI.getOptionalType(tag, "Type", SkinDocumentTypes.GENERAL_ARMOR_HEAD, SkinDocumentTypes::byName);
        this.settings = new SkinDocumentSettings(tag.func_74775_l("Settings"));
        this.properties = OptionalAPI.getOptionalSkinProperties(tag, "Properties");
        try {
            this.nodes = null;
            CompoundNBT rootTag = tag.func_74775_l("Nodes");
            if (!rootTag.isEmpty()) {
                this.nodes = new SkinDocumentNode(rootTag);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.nodes == null) {
            this.nodes = this._generateDefaultNode(this.type);
        }
        this.settings.setListener(this.listener);
        this.nodes.setListener(this.listener);
        this.listener.documentDidReload();
    }

    public void updateSettings(CompoundNBT tag) {
        this.settings.deserializeNBT(tag);
        this.listener.documentDidChangeSettings(tag);
    }

    public void updateProperties(CompoundNBT value) {
        this.properties.putAll(new SkinProperties.Changes(value));
        this.listener.documentDidChangeProperties(value);
    }

    public <T> void put(ISkinProperty<T> property, T value) {
        this.properties.put(property, value);
        SkinProperties.Changes changes = new SkinProperties.Changes();
        changes.put(property, value);
        this.listener.documentDidChangeProperties(changes.serializeNBT());
    }

    public <T> T get(ISkinProperty<T> property) {
        return this.properties.get(property);
    }

    public void beginEditing() {
        this.listener.documentWillBeginEditing();
    }

    public void endEditing() {
        this.listener.documentDidEndEditing();
    }

    public void addListener(SkinDocumentListener listener) {
        this.listener.addListener(listener);
    }

    public void removeListener(SkinDocumentListener listener) {
        this.listener.removeListener(listener);
    }

    public SkinDocumentListener getHandler() {
        return this.listener;
    }

    public SkinDocumentNode nodeById(String id) {
        return this._findNodeById(this.nodes, id);
    }

    public SkinDocumentNode getRoot() {
        return this.nodes;
    }

    public SkinDocumentSettings getSettings() {
        return this.settings;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public SkinDocumentType getType() {
        return this.type;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "type", this.type);
    }

    private SkinDocumentNode _findNodeById(SkinDocumentNode parent, String id) {
        if (id.equals(parent.getId())) {
            return parent;
        }
        for (SkinDocumentNode node : parent.children()) {
            SkinDocumentNode result = this._findNodeById(node, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private SkinDocumentSettings _generateSkinSettings() {
        return this.settings;
    }

    private SkinProperties _generateSkinProperties() {
        String name = this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        SkinProperties properties = new SkinProperties();
        properties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        properties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
        return properties;
    }

    private SkinDocumentNode _generateDefaultNode(SkinDocumentType category) {
        SkinDocumentNode root = new SkinDocumentNode("root", null);
        for (ISkinPartType iSkinPartType : category.getSkinPartTypes()) {
            ResourceLocation registryName = iSkinPartType.getRegistryName();
            SkinDocumentNode node = new SkinDocumentNode(registryName.func_110623_a(), null);
            node.setType(iSkinPartType);
            root.add(node);
        }
        root.add(new SkinDocumentNode("float", null));
        root.add(new SkinDocumentNode("static", null));
        return root;
    }

    protected static class Keys {
        public static final String NODES = "Nodes";
        public static final String TYPE = "Type";
        public static final String SETTINGS = "Settings";
        public static final String PROPERTIES = "Properties";

        protected Keys() {
        }
    }
}

