/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinResourceLocation;
import net.minecraft.inventory.EquipmentSlotType;

public final class SkinTypes {
    private static final ArrayList<ISkinType> ALL_SORTED_TYPES = new ArrayList();
    private static final HashMap<String, ISkinType> ALL_TYPES = new HashMap();
    public static final ISkinType UNKNOWN = SkinTypes.register("unknown", 255, SkinPartTypes.UNKNOWN);
    public static final ISkinType ARMOR_HEAD = SkinTypes.registerArmor("head", 1, EquipmentSlotType.HEAD, SkinPartTypes.BIPPED_HEAD);
    public static final ISkinType ARMOR_CHEST = SkinTypes.registerArmor("chest", 2, EquipmentSlotType.CHEST, SkinPartTypes.BIPPED_CHEST, SkinPartTypes.BIPPED_LEFT_ARM, SkinPartTypes.BIPPED_RIGHT_ARM);
    public static final ISkinType ARMOR_LEGS = SkinTypes.registerArmor("legs", 3, EquipmentSlotType.LEGS, SkinPartTypes.BIPPED_LEFT_THIGH, SkinPartTypes.BIPPED_RIGHT_THIGH, SkinPartTypes.BIPPED_SKIRT);
    public static final ISkinType ARMOR_FEET = SkinTypes.registerArmor("feet", 4, EquipmentSlotType.FEET, SkinPartTypes.BIPPED_LEFT_FOOT, SkinPartTypes.BIPPED_RIGHT_FOOT);
    public static final ISkinType ARMOR_WINGS = SkinTypes.registerArmor("wings", 5, null, SkinPartTypes.BIPPED_LEFT_WING, SkinPartTypes.BIPPED_RIGHT_WING);
    public static final ISkinType OUTFIT = SkinTypes.registerArmor("outfit", 6, null, ARMOR_HEAD, ARMOR_CHEST, ARMOR_LEGS, ARMOR_FEET, ARMOR_WINGS);
    public static final ISkinType ITEM_SWORD = SkinTypes.registerItem("sword", 7, ItemOverrideType.SWORD, SkinPartTypes.ITEM_SWORD);
    public static final ISkinType ITEM_SHIELD = SkinTypes.registerItem("shield", 8, ItemOverrideType.SHIELD, SkinPartTypes.ITEM_SHIELD);
    public static final ISkinType ITEM_BOW = SkinTypes.registerItem("bow", 9, ItemOverrideType.BOW, SkinPartTypes.ITEM_BOW0, SkinPartTypes.ITEM_BOW1, SkinPartTypes.ITEM_BOW2, SkinPartTypes.ITEM_BOW3, SkinPartTypes.ITEM_ARROW);
    public static final ISkinType ITEM_TRIDENT = SkinTypes.registerItem("trident", 17, ItemOverrideType.TRIDENT, SkinPartTypes.ITEM_TRIDENT);
    public static final ISkinType TOOL_PICKAXE = SkinTypes.registerItem("pickaxe", 10, ItemOverrideType.PICKAXE, SkinPartTypes.TOOL_PICKAXE);
    public static final ISkinType TOOL_AXE = SkinTypes.registerItem("axe", 11, ItemOverrideType.AXE, SkinPartTypes.TOOL_AXE);
    public static final ISkinType TOOL_SHOVEL = SkinTypes.registerItem("shovel", 12, ItemOverrideType.SHOVEL, SkinPartTypes.TOOL_SHOVEL);
    public static final ISkinType TOOL_HOE = SkinTypes.registerItem("hoe", 13, ItemOverrideType.HOE, SkinPartTypes.TOOL_HOE);
    public static final ISkinType ITEM = SkinTypes.register("item", 14, SkinPartTypes.ITEM);
    public static final ISkinType BLOCK = SkinTypes.register("block", 15, SkinPartTypes.BLOCK, SkinPartTypes.BLOCK_MULTI);
    public static final ISkinType ADVANCED = SkinTypes.register("part", 16, SkinPartTypes.ADVANCED);

    public static ISkinType byName(String registryName) {
        if (registryName == null) {
            return UNKNOWN;
        }
        if (!registryName.startsWith("armourers:")) {
            registryName = "armourers:" + registryName;
        }
        if (registryName.equals("armourers:skirt")) {
            return ARMOR_LEGS;
        }
        if (registryName.equals("armourers:arrow")) {
            return ITEM_BOW;
        }
        return ALL_TYPES.getOrDefault(registryName, UNKNOWN);
    }

    public static ArrayList<ISkinType> values() {
        return ALL_SORTED_TYPES;
    }

    private static ISkinType register(String name, int id, ISkinPartType ... parts) {
        return SkinTypes.register(name, new SkinType(name, id, ObjectUtils.map(parts)));
    }

    private static ISkinType registerArmor(String name, int id, EquipmentSlotType slotType, ISkinPartType ... parts) {
        return SkinTypes.register(name, new SkinType.Armor(name, id, slotType, ObjectUtils.map(parts)));
    }

    private static ISkinType registerArmor(String name, int id, EquipmentSlotType slotType, ISkinType ... types) {
        ArrayList<? extends ISkinPartType> partTypes = new ArrayList<ISkinPartType>();
        for (ISkinType type : types) {
            partTypes.addAll(type.getParts());
        }
        return SkinTypes.register(name, new SkinType.Armor(name, id, slotType, partTypes));
    }

    private static ISkinType registerItem(String name, int id, ItemOverrideType overrideType, ISkinPartType ... parts) {
        return SkinTypes.register(name, new SkinType.Tool(name, id, ObjectUtils.map(parts), overrideType::isOverrideItem));
    }

    private static ISkinType register(String name, SkinType type) {
        type.setRegistryName(new SkinResourceLocation("armourers", name));
        if (type.getParts().size() == 0) {
            ModLog.warn("A mod tried to register a skin type no skin type parts.", new Object[0]);
            return type;
        }
        if (ALL_TYPES.containsKey(type.getRegistryName().toString())) {
            ModLog.warn("A mod tried to register a skin type with a registry name that is in use.", new Object[0]);
            return type;
        }
        ALL_SORTED_TYPES.add(type);
        ALL_TYPES.put(type.getRegistryName().toString(), type);
        ModLog.debug("Registering Skin '{}'", type.getRegistryName());
        return type;
    }
}

