/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.util.Strings;

public class SkinnableMenu
extends AbstractBlockEntityMenu<SkinnableBlockEntity> {
    private final String title;
    private int row;
    private int column;
    private IInventory inventory;

    public SkinnableMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IContainerLevelAccess worldPos) {
        super((ContainerType)menuType, block, containerId, worldPos);
        this.title = ((SkinnableBlockEntity)this.blockEntity).getInventoryName();
        this.row = 3;
        this.column = 9;
        this.inventory = playerInventory.field_70458_d.func_71005_bN();
        if (!((SkinnableBlockEntity)this.blockEntity).isEnderInventory()) {
            this.row = ((SkinnableBlockEntity)this.blockEntity).getInventoryHeight();
            this.column = ((SkinnableBlockEntity)this.blockEntity).getInventoryWidth();
            this.inventory = ((SkinnableBlockEntity)this.blockEntity).getInventory();
        }
        int guiTop = 20;
        int guiMiddle = 6;
        int guiWidth = 176;
        this.addPlayerSlots((IInventory)playerInventory, 8, guiTop + this.row * 18 + guiMiddle + 16);
        this.addCustomSlots(this.inventory, (guiWidth - this.column * 18) / 2, guiTop);
        if (this.inventory != null) {
            this.inventory.func_174889_b(playerInventory.field_70458_d);
        }
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size());
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.inventory != null) {
            this.inventory.func_174886_c(player);
        }
    }

    protected void addCustomSlots(IInventory inventory, int x, int y) {
        if (inventory == null) {
            return;
        }
        for (int j = 0; j < this.row; ++j) {
            for (int i = 0; i < this.column; ++i) {
                this.func_75146_a(new Slot(inventory, i + j * this.column, x + 18 * i + 1, y + j * 18 + 1));
            }
        }
    }

    public ITextComponent getInventoryName() {
        if (Strings.isNotBlank((String)this.title)) {
            return TranslateUtils.formatted(this.title);
        }
        return TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.skinnable", new Object[0]);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }
}

