/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.blockentity.DyeTableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlot;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class DyeTableMenu
extends AbstractBlockEntityMenu<DyeTableBlockEntity> {
    private final ISkinPaintType[] paintTypes = new ISkinPaintType[]{SkinPaintTypes.DYE_1, SkinPaintTypes.DYE_2, SkinPaintTypes.DYE_3, SkinPaintTypes.DYE_4, SkinPaintTypes.DYE_5, SkinPaintTypes.DYE_6, SkinPaintTypes.DYE_7, SkinPaintTypes.DYE_8};
    private final IInventory inventory = ((DyeTableBlockEntity)this.blockEntity).getInventory();

    public DyeTableMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IContainerLevelAccess access) {
        super((ContainerType)menuType, block, containerId, access);
        this.addPlayerSlots((IInventory)playerInventory, 8, 108);
        this.addCustomSlots(this.inventory, 68, 36, 22, 22);
        this.addInputSlot(this.inventory, 8, 26, 23);
        this.addOutputSlot(this.inventory, 9, 26, 69);
    }

    public ItemStack getOutputStack() {
        return this.inventory.func_70301_a(9);
    }

    public void setOutputStack(ItemStack itemStack) {
        this.inventory.func_70299_a(9, itemStack);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    protected void addInputSlot(final IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_82869_a(PlayerEntity p_82869_1_) {
                return false;
            }

            public boolean func_75214_a(ItemStack itemStack) {
                return !SkinDescriptor.of(itemStack).isEmpty();
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (inventory.func_70301_a(9).func_190926_b()) {
                    DyeTableMenu.this.loadSkin(this.func_75211_c());
                }
            }
        });
    }

    protected void addOutputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){

            public boolean func_75214_a(ItemStack p_75214_1_) {
                return false;
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (!this.func_75216_d()) {
                    DyeTableMenu.this.loadSkin(ItemStack.field_190927_a);
                }
            }
        });
    }

    protected void addCustomSlots(IInventory inventory, int x, int y, int itemWidth, int itemHeight) {
        for (int i = 0; i < 8; ++i) {
            int ix = x + i % 4 * itemWidth;
            int iy = y + i / 4 * itemHeight;
            this.func_75146_a(new LockableSlot(inventory, i, ix, iy, SkinSlotType.DYE));
        }
    }

    protected void loadSkin(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.inventory.func_174888_l();
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        ColorScheme scheme = descriptor.getColorScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = ItemStack.field_190927_a;
            IPaintColor paintColor = scheme.getColor(this.paintTypes[i]);
            if (paintColor != null) {
                colorStack = new ItemStack((IItemProvider)ModItems.BOTTLE.get());
                ColorUtils.setColor(colorStack, paintColor);
            }
            this.inventory.func_70299_a(i, colorStack);
        }
        this.setOutputStack(itemStack.func_77946_l());
    }

    protected void applySkin(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        ColorScheme newScheme = new ColorScheme();
        for (int i = 0; i < this.paintTypes.length; ++i) {
            ItemStack colorStack = this.inventory.func_70301_a(i);
            IPaintColor paintColor = ColorUtils.getColor(colorStack);
            if (paintColor == null) continue;
            newScheme.setColor(this.paintTypes[i], paintColor);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (newScheme.equals(descriptor.getColorScheme())) {
            return;
        }
        descriptor = new SkinDescriptor(descriptor, newScheme);
        ItemStack newItemStack = itemStack.func_77946_l();
        SkinDescriptor.setDescriptor(newItemStack, descriptor);
        this.setOutputStack(newItemStack);
    }

    public class LockableSlot
    extends SkinSlot {
        public LockableSlot(IInventory inventory, int slot, int x, int y, SkinSlotType ... slotTypes) {
            super(inventory, slot, x, y, slotTypes);
        }

        @Override
        public boolean func_75214_a(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof BottleItem;
        }

        public void func_75218_e() {
            super.func_75218_e();
            DyeTableMenu.this.applySkin(DyeTableMenu.this.getOutputStack());
        }
    }
}

