/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import net.minecraft.util.ResourceLocation;

public class EntityProfile {
    private final ResourceLocation registryName;
    private final HashMap<ISkinType, Function<ISkinType, Integer>> supports;
    private final Collection<IEntityTypeProvider<?>> entities;
    private final boolean locked;

    public EntityProfile(ResourceLocation registryName, HashMap<ISkinType, Function<ISkinType, Integer>> supports, Collection<IEntityTypeProvider<?>> entities, boolean locked) {
        this.registryName = registryName;
        this.supports = supports;
        this.entities = entities;
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean canSupport(ISkinType type) {
        return this.supports.containsKey(type);
    }

    public int getMaxCount(ISkinType type) {
        Function<ISkinType, Integer> provider = this.supports.get(type);
        if (provider != null) {
            return provider.apply(type);
        }
        return 0;
    }

    public Collection<IEntityTypeProvider<?>> getEntities() {
        return this.entities;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

