/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.ticket;

import java.util.HashMap;
import java.util.HashSet;

public abstract class Ticket {
    public static Ticket limited(int time, float priority) {
        return new LimitedTime(time, priority);
    }

    public static Ticket normal(float priority) {
        return new Impl(priority);
    }

    public static Ticket list() {
        return Ticket.normal(0.0f);
    }

    public static Ticket wardrobe() {
        return Ticket.normal(0.0f);
    }

    public abstract void invalidate();

    public abstract void add(Object var1);

    public abstract boolean contains(Object var1);

    public abstract float priority(Object var1);

    protected static class LimitedTime
    extends Ticket {
        private final int interval;
        private final float priority;
        private final HashMap<Object, Long> identifiers = new HashMap();

        public LimitedTime(int interval, float priority) {
            this.interval = interval;
            this.priority = priority;
        }

        @Override
        public void invalidate() {
            this.identifiers.clear();
        }

        @Override
        public void add(Object key) {
            Long time = System.currentTimeMillis();
            this.identifiers.put(key, time);
        }

        @Override
        public boolean contains(Object key) {
            Long time = this.identifiers.get(key);
            if (time != null) {
                return System.currentTimeMillis() - time <= (long)this.interval;
            }
            return false;
        }

        @Override
        public float priority(Object key) {
            return this.priority;
        }
    }

    protected static class Impl
    extends Ticket {
        private final float priority;
        private final HashSet<Object> identifiers = new HashSet();

        protected Impl(float priority) {
            this.priority = priority;
        }

        @Override
        public void invalidate() {
            this.identifiers.clear();
        }

        @Override
        public void add(Object key) {
            this.identifiers.add(key);
        }

        @Override
        public boolean contains(Object key) {
            return this.identifiers.contains(key);
        }

        @Override
        public float priority(Object key) {
            return this.priority;
        }
    }
}

