/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.skin.ISkinArmorType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum SkinSlotType {
    HEAD(0, 0, 10, "head", SkinTypes.ARMOR_HEAD),
    CHEST(1, 10, 10, "chest", SkinTypes.ARMOR_CHEST),
    LEGS(2, 20, 10, "legs", SkinTypes.ARMOR_LEGS),
    FEET(3, 30, 10, "feet", SkinTypes.ARMOR_FEET),
    WINGS(4, 40, 10, "wings", SkinTypes.ARMOR_WINGS),
    SWORD(5, 50, 1, "sword", SkinTypes.ITEM_SWORD),
    SHIELD(6, 51, 1, "shield", SkinTypes.ITEM_SHIELD),
    BOW(7, 52, 1, "bow", SkinTypes.ITEM_BOW),
    TRIDENT(14, 57, 1, "trident", SkinTypes.ITEM_TRIDENT),
    PICKAXE(8, 53, 1, "pickaxe", SkinTypes.TOOL_PICKAXE),
    AXE(9, 54, 1, "axe", SkinTypes.TOOL_AXE),
    SHOVEL(10, 55, 1, "shovel", SkinTypes.TOOL_SHOVEL),
    HOE(11, 56, 1, "hoe", SkinTypes.TOOL_HOE),
    OUTFIT(12, 70, 10, "outfit", SkinTypes.OUTFIT),
    DYE(13, 80, 16, "dye", null);

    private final String name;
    private final int id;
    private final int index;
    private final int size;
    private final ISkinType skinType;

    private SkinSlotType(int id, int index, int size, String name, ISkinType skinType) {
        this.id = id;
        this.name = name;
        this.index = index;
        this.size = size;
        this.skinType = skinType;
        Helper.TOTAL_SIZE = Math.max(Helper.TOTAL_SIZE, index + size);
        Helper.NAMED_SLOTS.put(name, this);
        Helper.INDEXED_SLOTS.put(id, this);
    }

    @Nullable
    public static SkinSlotType by(int id) {
        return Helper.INDEXED_SLOTS.get(id);
    }

    @Nullable
    public static SkinSlotType of(String name) {
        return Helper.NAMED_SLOTS.get(name);
    }

    @Nullable
    public static SkinSlotType of(ISkinType skinType) {
        for (SkinSlotType slotType : SkinSlotType.values()) {
            if (!Objects.equals(slotType.skinType, skinType)) continue;
            return slotType;
        }
        return null;
    }

    @Nullable
    public static SkinSlotType of(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        if (itemStack.func_77973_b() instanceof BottleItem) {
            return DYE;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (!descriptor.isEmpty()) {
            return SkinSlotType.of(descriptor.getType());
        }
        return null;
    }

    public static int getMaxSlotSize() {
        return 10;
    }

    public static int getTotalSize() {
        return Helper.TOTAL_SIZE;
    }

    public static ISkinPaintType[] getSupportedPaintTypes() {
        return Helper.SLOT_TO_TYPES;
    }

    public static int getDyeSlotIndex(ISkinPaintType paintType) {
        int i;
        for (i = 0; i < Helper.SLOT_TO_TYPES.length && Helper.SLOT_TO_TYPES[i] != paintType; ++i) {
        }
        return DYE.getIndex() + i;
    }

    public ResourceLocation getIconSprite() {
        return ModConstants.key("item/slot/" + this.name);
    }

    public boolean isResizable() {
        return this != DYE && this.size > 1;
    }

    public boolean isArmor() {
        return this.skinType instanceof ISkinArmorType;
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    private static class Helper {
        static final HashMap<Integer, SkinSlotType> INDEXED_SLOTS = new HashMap();
        static final HashMap<String, SkinSlotType> NAMED_SLOTS = new HashMap();
        static final ISkinPaintType[] SLOT_TO_TYPES = new ISkinPaintType[]{SkinPaintTypes.DYE_1, SkinPaintTypes.DYE_2, SkinPaintTypes.DYE_3, SkinPaintTypes.DYE_4, SkinPaintTypes.DYE_5, SkinPaintTypes.DYE_6, SkinPaintTypes.DYE_7, SkinPaintTypes.DYE_8, SkinPaintTypes.SKIN, SkinPaintTypes.HAIR, SkinPaintTypes.EYES, SkinPaintTypes.MISC_1, SkinPaintTypes.MISC_2, SkinPaintTypes.MISC_3, SkinPaintTypes.MISC_4};
        static int TOTAL_SIZE = 0;

        private Helper() {
        }
    }
}

