/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class BlockPaintColor
implements IBlockPaintColor {
    public static final BlockPaintColor WHITE = new BlockPaintColor(PaintColor.WHITE);
    public static final BlockPaintColor EMPTY = new BlockPaintColor();
    protected IPaintColor paintColor;
    protected EnumMap<Side, IPaintColor> paintColors;

    public BlockPaintColor() {
    }

    public BlockPaintColor(IPaintColor paintColor) {
        this.paintColor = paintColor;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.paintColor = OptionalAPI.getOptionalPaintColor(tag, Side.fullyName(), null);
        this.paintColors = null;
        for (Side side : Side.values()) {
            IPaintColor paintColor = OptionalAPI.getOptionalPaintColor(tag, side.name, null);
            if (paintColor == null) continue;
            if (this.paintColors == null) {
                this.paintColors = new EnumMap(Side.class);
            }
            this.paintColors.put(side, paintColor);
        }
        this.mergePaintColorIfNeeded();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.paintColor != null) {
            OptionalAPI.putOptionalPaintColor(tag, Side.fullyName(), this.paintColor, null);
        }
        if (this.paintColors != null) {
            this.paintColors.forEach((side, paintColor) -> OptionalAPI.putOptionalPaintColor(tag, side.name, paintColor, null));
        }
        return tag;
    }

    public void putAll(IPaintColor paintColor) {
        this.paintColor = paintColor;
        this.paintColors = null;
    }

    @Override
    public void put(Direction dir, IPaintColor paintColor) {
        if (this.paintColors == null) {
            if (Objects.equals(this.paintColor, paintColor)) {
                return;
            }
            this.paintColors = this.getPaintColors(this.paintColor);
            this.paintColor = null;
        }
        Side side = Side.of(dir);
        if (paintColor != null) {
            this.paintColors.put(side, paintColor);
        } else {
            this.paintColors.remove((Object)side);
        }
        this.mergePaintColorIfNeeded();
    }

    @Override
    public IPaintColor get(Direction dir) {
        return this.getOrDefault(dir, null);
    }

    @Override
    public IPaintColor getOrDefault(Direction dir, IPaintColor defaultValue) {
        if (this.paintColor != null) {
            return this.paintColor;
        }
        if (this.paintColors != null) {
            return this.paintColors.getOrDefault((Object)Side.of(dir), defaultValue);
        }
        return defaultValue;
    }

    public Collection<IPaintColor> values() {
        if (this.paintColor != null) {
            return Collections.singleton(this.paintColor);
        }
        if (this.paintColors != null) {
            return this.paintColors.values();
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockPaintColor)) {
            return false;
        }
        BlockPaintColor that = (BlockPaintColor)o;
        return Objects.equals(this.paintColor, that.paintColor) && Objects.equals(this.paintColors, that.paintColors);
    }

    public int hashCode() {
        return Objects.hash(this.paintColor, this.paintColors);
    }

    @Override
    public boolean isEmpty() {
        if (this.paintColors != null) {
            return this.paintColors.isEmpty();
        }
        return this.paintColor == null;
    }

    @Override
    public boolean isPureColor() {
        return this.paintColor != null;
    }

    private void mergePaintColorIfNeeded() {
        if (this.paintColors == null) {
            return;
        }
        int total = 0;
        IPaintColor lastColor = null;
        for (IPaintColor paintColor : this.paintColors.values()) {
            if (lastColor != null && !lastColor.equals(paintColor)) {
                return;
            }
            lastColor = paintColor;
            ++total;
        }
        if (total == 6) {
            this.paintColor = lastColor;
            this.paintColors = null;
        }
    }

    private EnumMap<Side, IPaintColor> getPaintColors(IPaintColor paintColor) {
        EnumMap<Side, IPaintColor> paintColors = new EnumMap<Side, IPaintColor>(Side.class);
        if (paintColor != null) {
            for (Side side : Side.values()) {
                paintColors.put(side, paintColor);
            }
        }
        return paintColors;
    }

    public static enum Side {
        DOWN("Down", Direction.DOWN),
        UP("Up", Direction.UP),
        FRONT("Front", Direction.NORTH),
        BACK("Back", Direction.SOUTH),
        LEFT("Left", Direction.WEST),
        RIGHT("Right", Direction.EAST);

        final String name;
        final Direction direction;

        private Side(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public static Side of(Direction direction) {
            return Side.values()[direction.ordinal()];
        }

        public static String fullyName() {
            return "All";
        }

        public String getName() {
            return this.name;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }
}

