/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObjectBuilder;
import moe.plushie.armourers_workshop.core.skin.Skin;
import org.jetbrains.annotations.Nullable;

public class SkinCache {
    private static final ArrayDeque<Key> POOL = new ArrayDeque();
    public static SkinCache INSTANCE = new SkinCache();
    public Map<Skin, SkinRenderObjectBuilder> bufferBuilders = new HashMap<Skin, SkinRenderObjectBuilder>();

    public static Object borrowKey(Object ... objects) {
        Key key = POOL.poll();
        if (key == null) {
            key = new Key();
        }
        key.hash = Objects.hash(objects);
        Key.access$102(key, objects);
        return key;
    }

    public static void returnKey(Object key) {
        if (key instanceof Key) {
            Key.access$102((Key)key, null);
            POOL.push((Key)key);
        }
    }

    public void cache(Skin key, SkinRenderObjectBuilder buffer) {
        this.bufferBuilders.put(key, buffer);
    }

    @Nullable
    public SkinRenderObjectBuilder cache(Skin key) {
        return this.bufferBuilders.get(key);
    }

    public void clear() {
        this.bufferBuilders.clear();
    }

    public static class Key {
        private int hash;
        private Object[] objects;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.hash == key.hash && Arrays.equals(this.objects, key.objects);
        }

        public int hashCode() {
            return this.hash;
        }

        static /* synthetic */ Object[] access$102(Key x0, Object[] x1) {
            x0.objects = x1;
            return x1;
        }
    }

    public static class LRU<K, V> {
        private final Cache<K, V> cache;

        public LRU() {
            this.cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();
        }

        public LRU(int size) {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)size).expireAfterAccess(15L, TimeUnit.SECONDS).build();
        }

        public V computeIfAbsent(K key, Function<K, V> loader) {
            try {
                return (V)this.cache.get(key, () -> loader.apply(key));
            }
            catch (ExecutionException e) {
                return null;
            }
        }

        public void clear() {
            this.cache.cleanUp();
        }
    }
}

