/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IResourceManager;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.util.ResourceLocation;

public class DataPackLoader {
    private final ResourceLocation target;
    private final Function<ResourceLocation, IDataPackBuilder> provider;
    private final Runnable willLoadHandler;
    private final Runnable didLoadHandler;

    public DataPackLoader(String path, Function<ResourceLocation, IDataPackBuilder> provider, Runnable willLoadHandler, Runnable didLoadHandler) {
        this.target = ModConstants.key(path);
        this.provider = provider;
        this.willLoadHandler = willLoadHandler;
        this.didLoadHandler = didLoadHandler;
    }

    public CompletableFuture<Map<ResourceLocation, IDataPackBuilder>> prepare(IResourceManager resourceManager, Executor executor) {
        if (this.willLoadHandler != null) {
            this.willLoadHandler.run();
        }
        return CompletableFuture.supplyAsync(() -> {
            HashMap results = new HashMap();
            resourceManager.readResources(this.target, s -> s.endsWith(".json"), (location, inputStream) -> {
                IDataPackObject object = StreamUtils.fromPackObject(inputStream);
                if (object == null) {
                    return;
                }
                String path = SkinFileUtils.removeExtension(location.func_110623_a());
                ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), path);
                results.computeIfAbsent(location1, this.provider).append(object, (ResourceLocation)location);
            });
            return results;
        }, executor);
    }

    public void load(Map<ResourceLocation, IDataPackBuilder> results) {
        results.forEach((key, builder) -> builder.build());
        if (this.didLoadHandler != null) {
            this.didLoadHandler.run();
        }
    }
}

