/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.LocalDataService;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;

public class DataManager {
    private static final DataManager INSTANCE = new DataManager();

    public static DataManager getInstance() {
        return INSTANCE;
    }

    public InputStream loadSkinData(String identifier) throws IOException {
        ModLog.debug("'{}' => get skin input stream from data manager", identifier);
        if (DataDomain.isDatabase(identifier)) {
            String path = DataDomain.getPath(identifier);
            return LocalDataService.getInstance().getFile(path);
        }
        String path = SkinFileUtils.normalize(DataDomain.getPath(identifier));
        return this.loadStreamFromPath(path);
    }

    private InputStream loadStreamFromPath(String identifier) throws IOException {
        File file = new File(EnvironmentManager.getSkinLibraryDirectory(), identifier);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        file = new File(EnvironmentManager.getSkinLibraryDirectory(), identifier + ".armour");
        if (file.exists()) {
            return new FileInputStream(file);
        }
        throw new FileNotFoundException(identifier);
    }
}

