/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import moe.plushie.armourers_workshop.api.client.model.IHumanoidModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.client.model.IModelPartPose;
import moe.plushie.armourers_workshop.core.client.model.TransformModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVisibilityTransformer;
import moe.plushie.armourers_workshop.core.client.skinrender.ExtendedSkinRenderer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VillagerSkinRenderer<T extends LivingEntity, M extends IHumanoidModel>
extends ExtendedSkinRenderer<T, M> {
    private final TransformModel<T> transformModelRef = new TransformModel(0.0f);
    private final M transformModel = (IHumanoidModel)ObjectUtils.unsafeCast(ModelHolder.of(this.transformModelRef));

    public VillagerSkinRenderer(EntityProfile profile) {
        super(profile);
    }

    @Override
    protected void init(SkinVisibilityTransformer<M> transformer) {
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, IHumanoidModel::getLeftArmPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, IHumanoidModel::getRightArmPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_HEAD, IHumanoidModel::getHatPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_HEAD, IHumanoidModel::getHeadPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_HEAD, "hat_rim");
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_HEAD, "nose");
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_CHEST, IHumanoidModel::getBodyPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_CHEST, "jacket");
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, IHumanoidModel::getLeftLegPart);
        transformer.linkToPart(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, IHumanoidModel::getRightLegPart);
    }

    @Override
    public void willRender(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
        super.willRender(entity, model, renderData, context);
        this.transformModelRef.setup(entity, context.getLightmap(), context.getPartialTicks());
    }

    @Override
    public void willRenderModel(T entity, M model, SkinRenderData renderData, SkinRenderContext context) {
        super.willRenderModel(entity, model, renderData, context);
        this.copyRot(this.transformModel.getHeadPart(), model.getHeadPart());
    }

    private void copyRot(IModelPart model, IModelPart fromModel) {
        IModelPartPose pose1 = model.pose();
        IModelPartPose pose2 = fromModel.pose();
        pose1.setXRot(pose2.getXRot());
        pose1.setYRot(pose2.getYRot());
        pose1.setZRot(pose2.getZRot());
    }

    @Override
    public M getOverrideModel(M model) {
        return this.transformModel;
    }
}

