/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.skinrender.LivingSkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererManager {
    private static final SkinRendererManager INSTANCE = new SkinRendererManager();
    private boolean isReady = false;
    private final HashMap<IEntityTypeProvider<?>, EntityProfile> entities = new HashMap();
    private final ArrayList<SkinRenderer.Factory<SkinRenderer<?, ?>>> builders = new ArrayList();
    private final ArrayList<Pair<Class<?>, LivingSkinRenderer.Plugin<?, ?>>> plugins = new ArrayList();

    public static SkinRendererManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            RenderSystem.recordRenderCall(this::init);
            return;
        }
        RenderSystem.recordRenderCall(() -> this._init(entityRenderManager));
    }

    private void _init(EntityRendererManager entityRenderManager) {
        SkinRendererManager skinRendererManager = SkinRendererManager.getInstance();
        for (EntityRenderer renderer : entityRenderManager.field_178636_l.values()) {
            if (!(renderer instanceof LivingRenderer)) continue;
            skinRendererManager.setupRenderer(EntityType.field_200729_aH, (LivingRenderer)renderer, true);
        }
        entityRenderManager.field_78729_o.forEach((entityType1, entityRenderer) -> {
            if (entityRenderer instanceof LivingRenderer) {
                skinRendererManager.setupRenderer((EntityType<?>)entityType1, (LivingRenderer)((LivingRenderer)entityRenderer), true);
            }
        });
        this.entities.forEach(this::_bind);
        this.isReady = true;
    }

    public void unbind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Detach Entity Renderer '{}'", entityType.getRegistryName());
        this.entities.remove(entityType);
        if (this.isReady) {
            // empty if block
        }
    }

    public void bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Attach Entity Renderer '{}'", entityType.getRegistryName());
        this.entities.put(entityType, entityProfile);
        if (this.isReady) {
            this._bind(entityType, entityProfile);
        }
    }

    private void _bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        EntityType resolvedEntityType = (EntityType)entityType.get();
        if (resolvedEntityType == null) {
            return;
        }
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            return;
        }
        if (resolvedEntityType == EntityType.field_200729_aH) {
            for (EntityRenderer renderer2 : entityRenderManager.field_178636_l.values()) {
                if (!(renderer2 instanceof LivingRenderer)) continue;
                this.setupRenderer(resolvedEntityType, (LivingRenderer)renderer2, false);
            }
        }
        entityRenderManager.field_78729_o.forEach((entityType1, renderer) -> {
            if (resolvedEntityType.equals(entityType1) && renderer instanceof LivingRenderer) {
                this.setupRenderer(resolvedEntityType, (LivingRenderer)renderer, false);
            }
        });
    }

    public <T extends SkinRenderer<?, ?>> void registerPlugin(Class<T> targetType, LivingSkinRenderer.Plugin<?, ?> plugin) {
        this.plugins.add(Pair.of(targetType, plugin));
    }

    public <T extends LivingEntity, M extends IModel> void applyPlugins(SkinRenderer<T, M> renderer, Consumer<LivingSkinRenderer.Plugin<T, M>> applier) {
        this.plugins.forEach((Consumer<Pair<Class<?>, LivingSkinRenderer.Plugin<?, ?>>>)((Consumer<Pair>)pair -> {
            if (((Class)pair.getKey()).isInstance(renderer)) {
                applier.accept((LivingSkinRenderer.Plugin)ObjectUtils.unsafeCast((LivingSkinRenderer.Plugin)pair.getValue()));
            }
        }));
    }

    public void registerRenderer(SkinRenderer.Factory<SkinRenderer<?, ?>> builder) {
        this.builders.add(builder);
    }

    @Nullable
    public SkinRenderer<Entity, IModel> getRenderer(@Nullable Entity entity, @Nullable Model entityModel, @Nullable EntityRenderer<?> entityRenderer) {
        if (entity == null) {
            return null;
        }
        EntityType entityType = entity.func_200600_R();
        if (entityRenderer == null) {
            entityRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
        }
        if (entityModel == null) {
            entityModel = this.getModel(entityRenderer);
        }
        return this.getRenderer((EntityType<?>)entityType, (Model)entityModel, (EntityRenderer<?>)entityRenderer);
    }

    @Nullable
    protected <T extends Entity, M extends IModel> SkinRenderer<T, M> getRenderer(EntityType<?> entityType, Model entityModel, EntityRenderer<?> entityRenderer) {
        Storage storage = Storage.of(entityRenderer);
        return storage.computeIfAbsent(entityModel, key -> this.createRenderer(entityType, entityRenderer, entityModel));
    }

    @Nullable
    protected <T extends Entity, M extends IModel> SkinRenderer<T, M> createRenderer(EntityType<?> entityType, EntityRenderer<?> entityRenderer, Model entityModel) {
        EntityProfile entityProfile = ModEntityProfiles.getProfile(entityType);
        if (entityProfile == null) {
            return null;
        }
        for (SkinRenderer.Factory<SkinRenderer<?, ?>> builder : this.builders) {
            SkinRenderer<?, ?> skinRenderer = builder.create(entityType, entityRenderer, entityModel, entityProfile);
            if (skinRenderer == null) continue;
            return (SkinRenderer)ObjectUtils.unsafeCast(skinRenderer);
        }
        return null;
    }

    protected EntityModel<?> getModel(EntityRenderer<?> entityRenderer) {
        if (entityRenderer instanceof IEntityRenderer) {
            return ((IEntityRenderer)entityRenderer).func_217764_d();
        }
        return null;
    }

    private <T extends LivingEntity, V extends EntityModel<T>, M extends IModel> void setupRenderer(EntityType<?> entityType, LivingRenderer<T, V> livingRenderer, boolean autoInject) {
        LayerRenderer armorLayer = null;
        for (LayerRenderer layerRenderer : livingRenderer.field_177097_h) {
            if (layerRenderer instanceof BipedArmorLayer) {
                armorLayer = layerRenderer;
            }
            if (!(layerRenderer instanceof SkinWardrobeLayer)) continue;
            return;
        }
        if (autoInject && armorLayer == null) {
            return;
        }
        SkinRenderer<T, M> skinRenderer = this.getRenderer(entityType, (Model)livingRenderer.func_217764_d(), (EntityRenderer<?>)livingRenderer);
        if (skinRenderer != null) {
            livingRenderer.func_177094_a(new SkinWardrobeLayer<T, V, M>(skinRenderer, livingRenderer));
        }
    }

    public <T extends Entity, M extends IModel> void willRender(T entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        SkinRenderer<Entity, IModel> renderer = this.getRenderer(entity, entityModel, entityRenderer);
        if (renderer != null) {
            SkinRenderContext context1 = context.get();
            renderer.willRender(entity, (IModel)ModelHolder.of(entityModel), renderData, context1);
            context1.release();
        }
    }

    public <T extends Entity, M extends IModel> void willRenderModel(T entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        SkinRenderer<Entity, IModel> renderer = this.getRenderer(entity, entityModel, entityRenderer);
        if (renderer != null) {
            SkinRenderContext context1 = context.get();
            renderer.willRenderModel(entity, (IModel)ModelHolder.of(entityModel), renderData, context1);
            context1.release();
        }
    }

    public <T extends Entity, M extends IModel> void didRender(T entity, Model entityModel, @Nullable EntityRenderer<?> entityRenderer, SkinRenderData renderData, Supplier<SkinRenderContext> context) {
        SkinRenderer<Entity, IModel> renderer = this.getRenderer(entity, entityModel, entityRenderer);
        if (renderer != null) {
            SkinRenderContext context1 = context.get();
            renderer.didRender(entity, (IModel)ModelHolder.of(entityModel), renderData, context1);
            context1.release();
        }
    }

    public static class Storage<T extends Entity, M extends IModel> {
        private final HashMap<Object, SkinRenderer<T, M>> skinRenderers = new HashMap();

        public static <T extends Entity, V extends Model, M extends IModel> Storage<T, M> of(EntityRenderer<?> entityRenderer) {
            IAssociatedObjectProvider dataProvider = (IAssociatedObjectProvider)entityRenderer;
            Storage<T, M> storage = (Storage<T, M>)dataProvider.getAssociatedObject();
            if (storage == null) {
                storage = new Storage<T, M>();
                dataProvider.setAssociatedObject(storage);
            }
            return storage;
        }

        public SkinRenderer<T, M> computeIfAbsent(Model entityModel, Function<Object, SkinRenderer<T, M>> provider) {
            return this.skinRenderers.computeIfAbsent(this.getModelClass(entityModel), provider);
        }

        private Class<?> getModelClass(Model model) {
            if (model != null) {
                return model.getClass();
            }
            return Model.class;
        }
    }
}

